/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.impl.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.gcube.informationsystem.impl.entity.EntityImpl;
import org.gcube.informationsystem.impl.relation.ConsistsOfImpl;
import org.gcube.informationsystem.impl.relation.IsRelatedToImpl;
import org.gcube.informationsystem.model.entity.Facet;
import org.gcube.informationsystem.model.entity.Resource;
import org.gcube.informationsystem.model.exceptions.InvalidResource;
import org.gcube.informationsystem.model.relation.ConsistsOf;
import org.gcube.informationsystem.model.relation.Identifies;
import org.gcube.informationsystem.model.relation.IsRelatedTo;

public abstract class ResourceImpl
extends EntityImpl
implements Resource {
    protected Map<Facet, ConsistsOf<Resource, Facet>> addedFacets;
    protected Map<UUID, ConsistsOf<Resource, Facet>> attachedFacets = new HashMap<UUID, ConsistsOf<Resource, Facet>>();
    protected List<UUID> detachedFacets;
    protected Map<UUID, IsRelatedTo<Resource, Resource>> attachedResources;
    protected List<UUID> detachedResources;

    protected ResourceImpl() {
        this.addedFacets = new HashMap<Facet, ConsistsOf<Resource, Facet>>();
        this.detachedFacets = new ArrayList<UUID>();
        this.attachedResources = new HashMap<UUID, IsRelatedTo<Resource, Resource>>();
        this.detachedResources = new ArrayList<UUID>();
    }

    @Override
    public void addFacet(Facet facet) {
        this.addedFacets.put(facet, new ConsistsOfImpl<ResourceImpl, Facet>(this, facet, null));
    }

    @Override
    public void addFacet(Facet facet, ConsistsOf<Resource, Facet> relation) {
        this.addedFacets.put(facet, relation);
    }

    @Override
    public void attachFacet(UUID uuid) {
        this.attachedFacets.put(uuid, new ConsistsOfImpl(this, uuid, null));
    }

    @Override
    public void attachFacet(UUID uuid, ConsistsOf<Resource, Facet> relation) {
        this.attachedFacets.put(uuid, relation);
    }

    @Override
    public void detachFacet(Facet facet) {
        this.addedFacets.remove(facet);
        this.attachedFacets.remove(facet.getHeader().getUUID());
    }

    @Override
    public void detachFacet(UUID uuid) {
        this.attachedFacets.remove(uuid);
        for (Facet facet : this.addedFacets.keySet()) {
            if (facet.getHeader().getUUID().compareTo(uuid) != 0) continue;
            this.addedFacets.remove(facet);
            return;
        }
    }

    @Override
    public void attachResource(UUID uuid) {
        this.attachedResources.put(uuid, new IsRelatedToImpl(this, uuid, null));
    }

    @Override
    public void attachResource(UUID uuid, IsRelatedTo<Resource, Resource> relation) {
        this.attachedResources.put(uuid, relation);
    }

    @Override
    public void detachResource(UUID uuid) {
        this.attachedResources.remove(uuid);
    }

    @Override
    public List<? extends Facet> getIdentifierFacets() {
        ConsistsOf<Resource, Facet> consistOf;
        ArrayList<Facet> facets = new ArrayList<Facet>();
        for (Facet facet : this.addedFacets.keySet()) {
            consistOf = this.addedFacets.get(facet);
            if (!Identifies.class.isAssignableFrom(consistOf.getClass())) continue;
            facets.add(facet);
        }
        for (UUID uuid : this.attachedFacets.keySet()) {
            consistOf = this.attachedFacets.get(uuid);
            if (!Identifies.class.isAssignableFrom(consistOf.getClass())) continue;
        }
        return facets;
    }

    private void getRequirements() {
    }

    @Override
    public void validate() throws InvalidResource {
        ConsistsOf<Resource, Facet> consistOf;
        this.getRequirements();
        for (Facet facet : this.addedFacets.keySet()) {
            consistOf = this.addedFacets.get(facet);
            if (!Identifies.class.isAssignableFrom(consistOf.getClass())) continue;
        }
        for (UUID uuid : this.attachedFacets.keySet()) {
            consistOf = this.attachedFacets.get(uuid);
            if (!Identifies.class.isAssignableFrom(consistOf.getClass())) continue;
        }
        for (UUID uuid : this.attachedResources.keySet()) {
            IsRelatedTo<Resource, Resource> isRelatedTo = this.attachedResources.get(uuid);
        }
    }
}

