/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.types;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.HashSet;
import java.util.Set;
import org.gcube.informationsystem.model.annotations.Abstract;
import org.gcube.informationsystem.model.annotations.ISProperty;
import org.gcube.informationsystem.model.embedded.Embedded;
import org.gcube.informationsystem.model.entity.Entity;
import org.gcube.informationsystem.model.entity.Facet;
import org.gcube.informationsystem.model.entity.Resource;
import org.gcube.informationsystem.model.relation.ConsistsOf;
import org.gcube.informationsystem.model.relation.IsRelatedTo;
import org.gcube.informationsystem.model.relation.Relation;
import org.gcube.informationsystem.types.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeBinder {
    private static Logger logger = LoggerFactory.getLogger(TypeBinder.class);
    private static final String EDGE_CLASS_NAME = "E";
    private static final String VERTEX_CLASS_NAME = "V";
    public static final String NAME = "NAME";
    public static final String DESCRIPTION = "DESCRIPTION";

    private static String getStaticStringFieldByName(Class<?> type, String fieldName, String defaultValue) {
        try {
            Field field = type.getDeclaredField(fieldName);
            return (String)field.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            return defaultValue;
        }
    }

    public static String serializeType(Class<?> type) throws Exception {
        TypeDefinition def = TypeBinder.createTypeDefinition(type);
        ObjectMapper mapper = new ObjectMapper();
        String json = mapper.writeValueAsString((Object)def);
        return json;
    }

    protected static TypeDefinition createTypeDefinition(Class<?> type) {
        TypeDefinition typeDefinition = new TypeDefinition();
        typeDefinition.name = TypeBinder.getStaticStringFieldByName(type, NAME, type.getSimpleName());
        typeDefinition.description = TypeBinder.getStaticStringFieldByName(type, DESCRIPTION, "");
        typeDefinition.abstractType = false;
        if (type.isAnnotationPresent(Abstract.class)) {
            typeDefinition.abstractType = true;
        }
        if (Entity.class.isAssignableFrom(type)) {
            typeDefinition.superclasses = Resource.class.isAssignableFrom(type) ? TypeBinder.retrieveSuperClasses(type, Resource.class, Entity.class.getSimpleName()) : (Facet.class.isAssignableFrom(type) ? TypeBinder.retrieveSuperClasses(type, Facet.class, Entity.class.getSimpleName()) : TypeBinder.retrieveSuperClasses(type, Entity.class, VERTEX_CLASS_NAME));
        } else if (Relation.class.isAssignableFrom(type)) {
            typeDefinition.superclasses = IsRelatedTo.class.isAssignableFrom(type) ? TypeBinder.retrieveSuperClasses(type, IsRelatedTo.class, Relation.class.getSimpleName()) : (ConsistsOf.class.isAssignableFrom(type) ? TypeBinder.retrieveSuperClasses(type, ConsistsOf.class, Relation.class.getSimpleName()) : TypeBinder.retrieveSuperClasses(type, Relation.class, EDGE_CLASS_NAME));
        } else if (Embedded.class.isAssignableFrom(type)) {
            typeDefinition.superclasses = TypeBinder.retrieveSuperClasses(type, Embedded.class, null);
        } else {
            throw new RuntimeException("Serialization required");
        }
        if (!Resource.class.isAssignableFrom(type)) {
            typeDefinition.properties = TypeBinder.retrieveListOfProperties(type);
        }
        logger.trace("{} TypeDefinition {} ", type, (Object)typeDefinition);
        return typeDefinition;
    }

    protected static Set<Property> retrieveListOfProperties(Class<?> type) {
        HashSet<Property> properties = new HashSet<Property>();
        for (Method m : type.getDeclaredMethods()) {
            m.setAccessible(true);
            if (!m.isAnnotationPresent(ISProperty.class)) continue;
            ISProperty propAnnotation = m.getAnnotation(ISProperty.class);
            Property prop = TypeBinder.getProperty(propAnnotation, m);
            properties.add(prop);
            logger.trace("Property {} retrieved in type {} ", (Object)prop, (Object)type.getSimpleName());
        }
        return properties;
    }

    protected static String getPropertyNameFromMethodName(Method method) {
        String name = method.getName();
        if (name.startsWith("get")) {
            name = name.replace("get", "");
        }
        if (name.startsWith("is")) {
            name = name.replace("is", "");
        }
        if (name.length() > 0) {
            name = Character.toLowerCase(name.charAt(0)) + (name.length() > 1 ? name.substring(1) : "");
        }
        return name;
    }

    protected static Property getProperty(ISProperty propertyAnnotation, Method method) {
        String name = propertyAnnotation.name().isEmpty() ? TypeBinder.getPropertyNameFromMethodName(method) : propertyAnnotation.name();
        Property property = new Property();
        property.name = name;
        property.description = propertyAnnotation.description();
        property.mandatory = propertyAnnotation.mandatory();
        property.notnull = !propertyAnnotation.nullable();
        property.readonly = propertyAnnotation.readonly();
        if (propertyAnnotation.max() > 0) {
            property.max = propertyAnnotation.max();
        }
        if (propertyAnnotation.max() >= propertyAnnotation.min() && propertyAnnotation.min() > 0) {
            property.min = propertyAnnotation.min();
        }
        if (!propertyAnnotation.regexpr().isEmpty()) {
            property.regexpr = propertyAnnotation.regexpr();
        }
        logger.trace("Looking for property type {}", method.getReturnType());
        Class<?> type = method.getReturnType();
        property.type = Type.OType.EMBEDDED.getIntValue();
        if (Embedded.class.isAssignableFrom(type)) {
            property.linkedClass = TypeBinder.getStaticStringFieldByName(type, NAME, type.getSimpleName());
            property.type = Type.OType.EMBEDDED.getIntValue();
        } else if (Type.getTypeByClass(type) != null) {
            property.type = Type.getTypeByClass(type).getIntValue();
            if (property.type > 9 && property.type <= 12) {
                java.lang.reflect.Type genericReturnType = method.getGenericReturnType();
                logger.trace("Generic Return Type {} for method {}", (Object)genericReturnType, (Object)method);
                java.lang.reflect.Type[] actualTypeArguments = ((ParameterizedType)genericReturnType).getActualTypeArguments();
                java.lang.reflect.Type genericType = null;
                for (java.lang.reflect.Type t : actualTypeArguments) {
                    logger.trace("Generic Return Type {} for method {} - Actual Type Argument : {}", new Object[]{genericReturnType, method, t});
                    genericType = t;
                }
                Class genericClass = (Class)genericType;
                Type.OType linkedOType = Type.getTypeByClass(genericClass);
                if (linkedOType != null) {
                    property.linkedType = linkedOType.getIntValue();
                } else {
                    property.linkedClass = TypeBinder.getStaticStringFieldByName(genericClass, NAME, genericClass.getSimpleName());
                }
            }
        } else {
            throw new RuntimeException("Type " + type.getSimpleName() + " not reconized");
        }
        return property;
    }

    private static Set<String> retrieveSuperClasses(Class<?> type, Class<?> baseClass, String topSuperClass) {
        Class<?>[] interfaces;
        HashSet<String> interfaceList = new HashSet<String>();
        if (type == baseClass) {
            interfaceList.add(topSuperClass);
            return interfaceList;
        }
        for (Class<?> interfaceClass : interfaces = type.getInterfaces()) {
            if (interfaceClass == Embedded.class || !baseClass.isAssignableFrom(interfaceClass)) continue;
            interfaceList.add(TypeBinder.getStaticStringFieldByName(interfaceClass, NAME, interfaceClass.getSimpleName()));
        }
        return interfaceList;
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    public static class Property {
        private String name = "";
        private String description = "";
        private boolean mandatory = false;
        private boolean readonly = false;
        private boolean notnull = false;
        private Integer max = null;
        private Integer min = null;
        private String regexpr = null;
        private Integer linkedType = null;
        private String linkedClass = null;
        private Integer type = null;

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isMandatory() {
            return this.mandatory;
        }

        public boolean isReadonly() {
            return this.readonly;
        }

        public boolean isNotnull() {
            return this.notnull;
        }

        public Integer getMax() {
            return this.max;
        }

        public Integer getMin() {
            return this.min;
        }

        public String getRegexpr() {
            return this.regexpr;
        }

        public Integer getLinkedType() {
            return this.linkedType;
        }

        public String getLinkedClass() {
            return this.linkedClass;
        }

        public Integer getType() {
            return this.type;
        }

        public String toString() {
            return "Property [name=" + this.name + ", description=" + this.description + ", mandatory=" + this.mandatory + ", readonly=" + this.readonly + ", notnull=" + this.notnull + ", max=" + this.max + ", min=" + this.min + ", regexpr=" + this.regexpr + ", type = " + this.type + ", linkedType = " + this.linkedType + ", linkedClass = " + this.linkedClass + "]";
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    public static class TypeDefinition {
        protected String name;
        protected String description;
        protected boolean abstractType;
        protected Set<String> superclasses;
        protected Set<Property> properties;

        public String toString() {
            return "TypeDefinition [name=" + this.name + ", description=" + this.description + ", superclasses=" + this.superclasses + ", properties=" + this.properties + "]";
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isAbstractType() {
            return this.abstractType;
        }

        public Set<String> getSuperclasses() {
            return this.superclasses;
        }

        public Set<Property> getProperties() {
            return this.properties;
        }
    }
}

