/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.impl.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.gcube.informationsystem.model.embedded.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utility {
    private static Logger logger = LoggerFactory.getLogger(Utility.class);

    public static String getUUIDFromJSONString(String json) throws JsonProcessingException, IOException {
        logger.trace("Trying to get UUID from {} of {} ", (Object)Header.class.getSimpleName(), (Object)json);
        JsonNode jsonNode = Utility.getJSONNode(json);
        JsonNode header = jsonNode.get("header");
        String uuid = header.get("uuid").asText();
        logger.trace("UUID got from {} is : {} ", (Object)json, (Object)uuid);
        return uuid;
    }

    public static JsonNode getJSONNode(String json) throws JsonProcessingException, IOException {
        if (json == null || json.compareTo("") == 0) {
            return null;
        }
        logger.trace("Trying to get Jsonnode from {}", (Object)json);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonNode = mapper.readTree(json);
        return jsonNode;
    }
}

