/**
 * 
 */
package org.gcube.informationsystem.model.entity;

import java.util.List;
import java.util.UUID;

import org.gcube.informationsystem.model.annotations.Abstract;
import org.gcube.informationsystem.model.exceptions.InvalidResource;
import org.gcube.informationsystem.model.relation.ConsistsOf;
import org.gcube.informationsystem.model.relation.IsRelatedTo;

/**
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 */
@Abstract
public interface Resource extends Entity {
	
	public static final String NAME = Resource.class.getSimpleName();
	
	public List<? extends Facet> getIdentifierFacets();
	
	
	
	public void addFacet(Facet facet);
	
	public void addFacet(Facet facet, ConsistsOf<Resource, Facet> relation);
	
	
	public void attachFacet(UUID uuid);
	
	public void attachFacet(UUID uuid, ConsistsOf<Resource, Facet> relation);
	
	
	public void detachFacet(Facet facet);
	
	public void detachFacet(UUID uuid);
	
	
	
	public void attachResource(UUID uuid);
	
	public void attachResource(UUID uuid, IsRelatedTo<Resource, Resource> relation);
	
	public void detachResource(UUID uuid);
	
	@Override
	public void validate() throws InvalidResource;
	
}
