/**
 * 
 */
package org.gcube.informationsystem.impl.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import org.gcube.informationsystem.impl.relation.ConsistsOfImpl;
import org.gcube.informationsystem.impl.relation.IsRelatedToImpl;
import org.gcube.informationsystem.model.entity.Facet;
import org.gcube.informationsystem.model.entity.Resource;
import org.gcube.informationsystem.model.exceptions.InvalidResource;
import org.gcube.informationsystem.model.relation.ConsistsOf;
import org.gcube.informationsystem.model.relation.Identifies;
import org.gcube.informationsystem.model.relation.IsRelatedTo;

/**
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 */
public abstract class ResourceImpl extends EntityImpl implements Resource {

	protected Map<Facet, ConsistsOf<Resource, Facet>> addedFacets;
	
	protected Map<UUID, ConsistsOf<Resource, Facet>> attachedFacets;
	protected List<UUID> detachedFacets;
	
	protected Map<UUID, IsRelatedTo<Resource, Resource>> attachedResources;
	protected List<UUID> detachedResources;
	
	/**
	 * @param name
	 * @param description
	 * @param version
	 */
	protected ResourceImpl() {
		super();
		
		attachedFacets = new HashMap<>();
		addedFacets = new HashMap<>();
		detachedFacets = new ArrayList<>();
		
		attachedResources = new HashMap<>();
		detachedResources = new ArrayList<>();
	}
	
	@Override
	public void addFacet(Facet facet) {
		addedFacets.put(facet, new ConsistsOfImpl<Resource, Facet>(this, facet, null));
	}

	@Override
	public void addFacet(Facet facet, ConsistsOf<Resource, Facet> relation) {
		addedFacets.put(facet, relation);
	}

	@Override
	public void attachFacet(UUID uuid) {
		attachedFacets.put(uuid, new ConsistsOfImpl<Resource, Facet>(this, uuid, null));
	}

	@Override
	public void attachFacet(UUID uuid, ConsistsOf<Resource, Facet> relation) {
		attachedFacets.put(uuid, relation);
	}
	
	@Override
	public void detachFacet(Facet facet){
		addedFacets.remove(facet);
		attachedFacets.remove(facet.getHeader().getUUID());
	}
	
	@Override
	public void detachFacet(UUID uuid){
		attachedFacets.remove(uuid);
		for(Facet facet : addedFacets.keySet()){
			if(facet.getHeader().getUUID().compareTo(uuid)==0){
				addedFacets.remove(facet);
				return;
			}
		}
	}

	@Override
	public void attachResource(UUID uuid) {
		attachedResources.put(uuid, new IsRelatedToImpl<Resource, Resource>(this, uuid, null));
	}

	@Override
	public void attachResource(UUID uuid, IsRelatedTo<Resource, Resource> relation) {
		attachedResources.put(uuid, relation);
	}

	@Override
	public void detachResource(UUID uuid) {
		attachedResources.remove(uuid);
	}
	
	@Override
	public List<? extends Facet> getIdentifierFacets() {
		List<Facet> facets = new ArrayList<>();
		for(Facet facet : addedFacets.keySet()){
			ConsistsOf<Resource, Facet> consistOf = addedFacets.get(facet);
			if(Identifies.class.isAssignableFrom(consistOf.getClass())){
				facets.add(facet);
			}
		}
		
		for(UUID uuid : attachedFacets.keySet()){
			ConsistsOf<Resource, Facet> consistOf = attachedFacets.get(uuid);
			if(Identifies.class.isAssignableFrom(consistOf.getClass())){
				// TODO facets.add();
			}
		}
		return facets;
	}

	private void getRequirements(){
		// TODO
	}
	
	@Override
	public void validate() throws InvalidResource {
		// TODO
		getRequirements();
		
		for(Facet facet : addedFacets.keySet()){
			ConsistsOf<Resource, Facet> consistOf = addedFacets.get(facet);
			if(Identifies.class.isAssignableFrom(consistOf.getClass())){
				
			}
			
			// TODO
		}
		
		for(UUID uuid : attachedFacets.keySet()){
			ConsistsOf<Resource, Facet> consistOf = attachedFacets.get(uuid);
			
			// TODO
			
			if(Identifies.class.isAssignableFrom(consistOf.getClass())){
				
			}
		}
		
		for(UUID uuid : attachedResources.keySet()){
			IsRelatedTo<Resource, Resource> relatedTo = attachedResources.get(uuid);
			
			// TODO
		}
		
	}


}
