/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.icproxy.resources;

import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="GenericResource")
public class GenericResourceResource {
    private static final Logger log = LoggerFactory.getLogger(GenericResourceResource.class);

    @GET
    @Path(value="/{secondaryType}/{name}")
    @Produces(value={"application/xml"})
    public List<GenericResource> retrieveByTypeAndName(@NotNull @PathParam(value="secondaryType") String secondaryType, @NotNull @PathParam(value="name") String resourceName, @QueryParam(value="scope") String scope) {
        log.info("genericResource called with secondaryType {} and name {} in scope {}", new Object[]{secondaryType, resourceName, scope});
        ScopeProvider.instance.set(scope);
        SimpleQuery query = this.createSecondaryTypeQuery(secondaryType).addCondition(String.format("$resource/Profile/Name/text() eq '%s'", resourceName));
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List endpoints = client.submit((Query)query);
        log.debug("retrieved resources are " + endpoints.size());
        return endpoints;
    }

    @GET
    @Path(value="/{secondaryType}")
    @Produces(value={"application/xml"})
    public List<GenericResource> retrieveByType(@NotNull @PathParam(value="secondaryType") String secondaryType, @NotNull @PathParam(value="name") String resourceName, @QueryParam(value="scope") String scope) {
        log.info("genericResource called with secondaryType {} in scope {}", (Object)secondaryType, (Object)scope);
        ScopeProvider.instance.set(scope);
        SimpleQuery query = this.createSecondaryTypeQuery(secondaryType);
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List endpoints = client.submit((Query)query);
        log.debug("retrieved resources are " + endpoints.size());
        return endpoints;
    }

    SimpleQuery createSecondaryTypeQuery(String secondaryTpe) {
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition(String.format("$resource/Profile/SecondaryType/text() eq '%s'", secondaryTpe));
        return query;
    }
}

