/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.storagehandling;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.zip.Adler32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.informationsystem.notifier.ISNotifier;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.SecurityCredentials;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.indexmanagement.common.IndexException;
import org.gcube.indexmanagement.common.IndexNotificationConsumer;
import org.gcube.indexmanagement.common.IndexUpdaterWSResource;
import org.gcube.indexmanagement.common.IndexWSResource;
import org.gcube.indexmanagement.storagehandling.DeltaListManagementWrapper;
import org.gcube.indexmanagement.storagehandling.RemoteDeltaListManager;
import org.gcube.indexmanagement.storagehandling.stubs.ConnectUpdaterResponse;
import org.gcube.indexmanagement.storagehandling.stubs.DeltaActionType;
import org.gcube.indexmanagement.storagehandling.stubs.DeltaFileInfoType;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.core.notification.SubscriptionManager;
import org.oasis.wsrf.lifetime.Destroy;

public class DeltaFileUploader {
    private static GCUBELog logger = new GCUBELog(DeltaFileUploader.class);
    private DeltaListManagementWrapper manager;
    private int connectionID;
    private volatile boolean doDieAfterCurrentUploads = false;
    private String deltaFileCollectionID = null;
    private LinkedList<DeltaFileInfoType> uploadQueue;
    private IndexNotificationConsumer notificationConsumer;
    private SubscriptionManager removalSubscription;
    private String indexID;
    private IndexUpdaterWSResource resource;
    Thread cmsUploader = new Thread(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String deltaPath = null;
            DeltaFileInfoType deltaInfo = null;
            File deltaFile = null;
            File zipFile = null;
            String documentID = null;
            while (true) {
                LinkedList linkedList = DeltaFileUploader.this.uploadQueue;
                synchronized (linkedList) {
                    while (DeltaFileUploader.this.uploadQueue.size() == 0) {
                        try {
                            if (!DeltaFileUploader.this.doDieAfterCurrentUploads) {
                                Thread.yield();
                                if (Thread.currentThread().isInterrupted()) {
                                    logger.debug((Object)"Uploader thread cancelled after cms upload.");
                                    DeltaFileUploader.this.cleanUp(documentID, deltaFile, zipFile);
                                    DeltaFileUploader.this.shutdown();
                                    return;
                                }
                                DeltaFileUploader.this.uploadQueue.wait();
                                continue;
                            }
                            logger.debug((Object)"Uploader thread done");
                            DeltaFileUploader.this.shutdown();
                            return;
                        }
                        catch (InterruptedException ie) {
                            logger.debug((Object)"Uploader thread cancelled while waiting");
                            DeltaFileUploader.this.cleanUp(documentID, deltaFile, zipFile);
                            DeltaFileUploader.this.shutdown();
                            return;
                        }
                    }
                    deltaInfo = (DeltaFileInfoType)DeltaFileUploader.this.uploadQueue.removeLast();
                    deltaPath = deltaInfo.getDeltaFileID();
                    DeltaFileUploader.this.uploadQueue.notifyAll();
                }
                try {
                    deltaFile = new File(deltaPath);
                    logger.debug((Object)("zipping: " + deltaPath + " of size: " + deltaFile.length()));
                    zipFile = DeltaFileUploader.this.zip(deltaFile);
                    Thread.yield();
                    if (Thread.currentThread().isInterrupted()) {
                        logger.debug((Object)"Uploader thread cancelled after zipping.");
                        DeltaFileUploader.this.shutdown();
                        return;
                    }
                    logger.debug((Object)("uploading: " + zipFile.getAbsolutePath() + " of size: " + zipFile.length()));
                    documentID = DeltaFileUploader.this.cmsUpload(zipFile);
                    if (!DeltaFileUploader.this.removeFileOrDir(deltaFile)) {
                        logger.error((Object)("Unable to completely delete deltaFile: " + deltaPath));
                    }
                    if (!zipFile.delete()) {
                        logger.error((Object)("Unable to completely delete zipFile: " + zipFile.getAbsolutePath()));
                    }
                    deltaInfo = new DeltaFileInfoType(deltaInfo.getDeltaAction(), documentID, deltaInfo.getDocumentCount(), deltaInfo.getIndexTypeID());
                    Thread.yield();
                    if (Thread.currentThread().isInterrupted()) {
                        logger.debug((Object)"Uploader thread cancelled after cms upload.");
                        DeltaFileUploader.this.cleanUp(documentID, deltaFile, zipFile);
                        DeltaFileUploader.this.shutdown();
                        return;
                    }
                    DeltaFileUploader.this.manager.mergeDeltaFile(deltaInfo);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)("Uploading and merging the delta file \"" + deltaPath + "\" failed."), (Throwable)e);
                    continue;
                }
                break;
            }
        }
    });

    public DeltaFileUploader(String indexID, IndexUpdaterWSResource resource, GCUBEServiceContext ctx) throws Exception {
        this(resource, new RemoteDeltaListManager(indexID, ctx, resource.getManagementResourceNamespace()), indexID, ctx);
    }

    private DeltaFileUploader(IndexUpdaterWSResource resource, DeltaListManagementWrapper manager, String indexID, GCUBEServiceContext ctx) throws Exception {
        logger.debug((Object)">>>>> Constructing DeltaFileUploader");
        this.manager = manager;
        this.indexID = indexID;
        this.resource = resource;
        this.uploadQueue = new LinkedList();
        ConnectUpdaterResponse connectResponse = manager.connectUpdater();
        this.deltaFileCollectionID = connectResponse.getDeltaFileCollectionID();
        this.subscribeForIndexRemoval(ctx.getScope());
        this.connectionID = connectResponse.getConnectionID();
        ctx.setScope(this.cmsUploader, ctx.getScope());
        ctx.useCredentials(this.cmsUploader, new SecurityCredentials[]{ctx.getCredentials()});
        this.cmsUploader.start();
        logger.debug((Object)"<<<<< Constructing DeltaFileUploader");
    }

    public void upload(String deltaFileName, String indexTypeID, int documentCount) {
        logger.debug((Object)("adding to upload queue: " + deltaFileName + " of size: " + new File(deltaFileName).length()));
        this.upload(deltaFileName, DeltaActionType.Addition, indexTypeID, documentCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(String deltaFileName, DeltaActionType action, String indexTypeID, int documentCount) {
        LinkedList<DeltaFileInfoType> linkedList = this.uploadQueue;
        synchronized (linkedList) {
            this.uploadQueue.addFirst(new DeltaFileInfoType(action, deltaFileName, documentCount, indexTypeID));
            this.uploadQueue.notifyAll();
        }
    }

    public int getConnectionID() {
        return this.connectionID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LinkedList<DeltaFileInfoType> linkedList = this.uploadQueue;
        synchronized (linkedList) {
            this.doDieAfterCurrentUploads = true;
            this.uploadQueue.notifyAll();
        }
    }

    private void shutdown() {
        try {
            this.manager.disconnectUpdater(this.connectionID);
        }
        catch (Exception e) {
            logger.error((Object)"Unable to disconnect updater: ", (Throwable)e);
        }
        try {
            if (this.removalSubscription != null) {
                this.removalSubscription.destroy(new Destroy());
            }
        }
        catch (Exception e) {
            logger.error((Object)"Remove IndexRemoval notification subscription: ", (Throwable)e);
        }
    }

    private File zip(File delta) throws Exception {
        String entryPath;
        File[] inputFileList;
        File zipFile = new File(delta.getParentFile(), delta.getName() + ".zip");
        FileOutputStream out = new FileOutputStream(zipFile);
        CheckedOutputStream checksum = new CheckedOutputStream(out, new Adler32());
        ZipOutputStream zipOut = new ZipOutputStream(new BufferedOutputStream(checksum));
        if (delta.isDirectory()) {
            inputFileList = delta.listFiles(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return !f.isDirectory();
                }
            });
            entryPath = delta.getName() + "/";
        } else {
            inputFileList = new File[]{delta};
            entryPath = "";
        }
        for (int i = 0; i < inputFileList.length; ++i) {
            int len;
            FileInputStream in = new FileInputStream(inputFileList[i]);
            byte[] buf = new byte[1024];
            ZipEntry entry = new ZipEntry(entryPath + inputFileList[i].getName());
            zipOut.putNextEntry(entry);
            logger.debug((Object)entry.getName());
            while ((len = in.read(buf)) >= 0) {
                zipOut.write(buf, 0, len);
            }
            in.close();
            zipOut.closeEntry();
        }
        zipOut.close();
        return zipFile;
    }

    private String cmsUpload(File uploadFile) throws Exception {
        StringBuilder cmsID = new StringBuilder();
        try {
            if (this.deltaFileCollectionID == null) {
                logger.error((Object)"There is no delta collection ID during delta file upload to CMS ");
                throw new Exception("No delta collection ID during delta file upload to CMS ");
            }
            logger.trace((Object)"trying to create a writer");
            ScopeProvider.instance.set(this.resource.getServiceContext().getScope().toString());
            IClient client = new StorageClient("Index", "StorageHandler", "delta", AccessType.SHARED).getClient();
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEEE MMM dd HH:mm:ss:SSS yyyy");
            String localFile = uploadFile.getAbsolutePath();
            String remoteFile = this.deltaFileCollectionID + "/" + Calendar.getInstance().getTimeInMillis();
            logger.info((Object)("PUT local : " + localFile + " , remote : " + remoteFile));
            String id = client.put(true).LFile(localFile).RFile(remoteFile);
            logger.info((Object)("upload id : " + id));
            cmsID.append(id);
        }
        catch (Exception e) {
            throw new Exception("Failed to upload delta file to CMS: " + uploadFile.getAbsolutePath(), e);
        }
        String OID = cmsID.toString();
        logger.info((Object)("Uploaded delta file: " + uploadFile.getAbsolutePath() + " to CMS, OID = " + OID));
        return OID;
    }

    private void cleanUp(String cmsID, File delta, File zip) {
        try {
            if (this.deltaFileCollectionID == null) {
                logger.error((Object)"There is no delta collection ID during delta file deletion from CMS ");
                throw new Exception("No delta collection ID during delta file deletion from CMS ");
            }
            ScopeProvider.instance.set(this.resource.getServiceContext().getScope().toString());
            IClient client = new StorageClient("Index", "StorageHandler", "delta", AccessType.SHARED).getClient();
            logger.info((Object)("REMOVE " + cmsID));
            client.remove().RFile(cmsID);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to delete object with OID = " + cmsID + " from CMS."), (Throwable)e);
        }
        if (delta != null && !this.removeFileOrDir(delta)) {
            logger.error((Object)("Failed to delete local delta file: " + delta.getAbsolutePath()));
        }
        if (zip != null && !this.removeFileOrDir(zip)) {
            logger.error((Object)("Failed to delete local zipped delta file: " + zip.getAbsolutePath()));
        }
    }

    private void subscribeForIndexRemoval(GCUBEScope scope) {
        try {
            this.notificationConsumer = new ConsumerNotification(scope);
            this.removalSubscription = this.manager.subscribeForIndexRemoval(this.notificationConsumer);
            logger.debug((Object)"Uploader subscribed for removal notification.");
        }
        catch (Exception e) {
            logger.error((Object)"Failed to subscribe for index removal", (Throwable)e);
        }
    }

    private boolean removeFileOrDir(File file) {
        if (file.canRead()) {
            String[] files;
            if (file.isDirectory() && (files = file.list()) != null) {
                for (int i = 0; i < files.length; ++i) {
                    this.removeFileOrDir(new File(file, files[i]));
                }
            }
            return file.delete();
        }
        return false;
    }

    private void destroyResource() throws IndexException {
        try {
            this.cmsUploader.interrupt();
            this.resource.getPorttypeContext().getWSHome().remove((ResourceKey)this.resource.getID());
        }
        catch (Exception e) {
            throw new IndexException((Throwable)e);
        }
    }

    public class ConsumerNotification
    extends IndexNotificationConsumer {
        public ConsumerNotification(GCUBEScope scope) {
            super((IndexWSResource)DeltaFileUploader.this.resource, scope);
        }

        protected void onNewNotification(ISNotifier.NotificationEvent event) {
            try {
                logger.debug((Object)("DeltaFileUploader received index removal notification (IndexID: " + DeltaFileUploader.this.indexID + ")"));
                DeltaFileUploader.this.destroyResource();
            }
            catch (Exception e) {
                logger.error((Object)"Failed to process received notification", (Throwable)e);
            }
        }
    }
}

