package org.gcube.indexmanagement.storagehandling;

import java.io.File;

import org.gcube.indexmanagement.common.IndexException;

/**
 * Defines a set of operations that can be used to merge additions or deletions of
 * delta files with an index.
 */
public interface IndexReplicator {
	
	/**
	 * Merges a delta file addition with an index
	 * @param deltaFile the delta file to merge
	 * @param fileID the ID of the delta file
	 * @param documentCount the number of documents in the delta file
	 * @throws IndexException
	 */
    public void mergeAddition(File deltaFile, String fileID, int documentCount) throws IndexException;
    
    /**
	 * Merges a delta file deletion with an index
	 * @param deltaFile the delta file to delete
	 * @param fileID the ID of the delta file
	 * @param documentCount the number of documents in the delta file
	 * @throws IndexException
	 */
    public void mergeDeletion(File deltaFile, String fileID, int documentCount) throws IndexException;
    
    /**
     * Erases all the contents of the index
     * @throws IndexException
     */
    public void clearIndex() throws IndexException;
}
