/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.textextractor.extractors;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gcube.textextractor.extractors.InformationExtractor;
import org.gcube.textextractor.helpers.ExtractorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVAutocompleteExtractor
extends InformationExtractor {
    private static final Logger logger = LoggerFactory.getLogger(CSVAutocompleteExtractor.class);

    /*
     * Exception decompiling
     */
    @Override
    public Map<String, String> extractFieldsFromFile(String filename) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public List<Map<String, String>> extractInfo(String path) throws FileNotFoundException {
        ArrayList<Map<String, String>> extractedInfo = new ArrayList<Map<String, String>>();
        int cnt = 0;
        List<String> filenames = ExtractorHelper.getFilenames(path);
        for (String filename : filenames) {
            logger.info("Processing file : " + ++cnt + " " + filename);
            try {
                Map<String, String> info = this.extractFieldsFromFile(filename);
                long part_start_time = System.currentTimeMillis();
                Map<String, String> enriched = this.enrichRecord(info, filename);
                long part_end_time = System.currentTimeMillis();
                logger.info("~> field enrichment time  : " + (double)(part_end_time - part_start_time) / 1000.0 + " secs");
                extractedInfo.add(enriched);
            }
            catch (Exception e) {
                logger.error("error while extracting info from : " + filename + " . will skip this file", (Throwable)e);
            }
        }
        return extractedInfo;
    }

    @Override
    public Map<String, String> enrichRecord(Map<String, String> record, String filename) {
        return record;
    }

    @Override
    public String convertInfoToRowset(Map<String, String> info) {
        String documentID = info.get("uri");
        info.remove("uri");
        return ExtractorHelper.createRowseFromFields(documentID, "faoAutocompleteCollection", "SmartfishAutocompleteFT", info.get("language"), info);
    }

    private void gatherInfo(Map<String, Set<String>> totalInfo, String fieldName, String value) {
        if (value == null || value.trim().length() == 0) {
            return;
        }
        totalInfo.get(fieldName).add(value.trim());
    }
}

