/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.lucenewrapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.indexmanagement.gcqlwrapper.GcqlProcessor;
import org.gcube.indexmanagement.gcqlwrapper.GcqlQueryContainer;
import org.gcube.indexmanagement.lucenewrapper.LuceneGcqlQueryContainer;
import org.gcube.indexmanagement.lucenewrapper.LuceneSearcher;
import org.gcube.indexmanagement.lucenewrapper.QuerySnippetTermsPair;
import org.gcube.indexmanagement.resourceregistry.RRadaptor;
import search.library.util.cql.query.tree.GCQLAndNode;
import search.library.util.cql.query.tree.GCQLNode;
import search.library.util.cql.query.tree.GCQLNotNode;
import search.library.util.cql.query.tree.GCQLOrNode;
import search.library.util.cql.query.tree.GCQLProjectNode;
import search.library.util.cql.query.tree.GCQLQueryTreeManager;
import search.library.util.cql.query.tree.GCQLTermNode;
import search.library.util.cql.query.tree.ModifierSet;

public class LuceneGcqlProcessor
extends GcqlProcessor {
    static GCUBELog logger = new GCUBELog(LuceneGcqlProcessor.class);
    private static final String LUCENE_AND = " AND ";
    private static final String LUCENE_OR = " OR ";
    private static final String LUCENE_NOT = " NOT ";
    private LinkedHashMap<String, String> projectedFields = new LinkedHashMap();
    private HashMap<String, ArrayList<String>> snippetTerm = new HashMap();

    public static void main(String[] args) {
        ArrayList<String> presentable = new ArrayList<String>();
        ArrayList<String> searchable = new ArrayList<String>();
        presentable.add("title");
        presentable.add("author");
        presentable.add("year");
        presentable.add("code");
        searchable.add("title");
        searchable.add("author");
        searchable.add("year");
        searchable.add("description");
        searchable.add("anotations");
        String query = "((((gDocCollectionID == \"c5b83790-f35f-11dd-9a37-9b05ac676cca\") and (gDocCollectionLang == \"en\"))) and (((79697524-e3bf-457b-891a-faa3a9b0385f contains image) and (0da5e30a-a864-4686-9b5a-307db2c8c8a6 contains map)))) project 79697524-e3bf-457b-891a-faa3a9b0385f";
        query = "((((gDocCollectionID == \"14c1decd-347f-4783-81be-53119af7acf1\") and (gDocCollectionLang == \"en\"))) and (64130c65-c584-4fb7-b75f-337998462c87 = a*)) project 065725b6-e39b-40dd-bc86-acaa6aa3aedf 06785d3a-6812-4eb0-9730-dfcaea28e7e3 128c7cb9-ca15-4145-ab68-179086966646 ec208ad5-4e05-4761-a774-ec54f6c41a75 2ada6c76-1501-4a78-96b7-d0740e68d41e c428abff-db06-405e-a9b1-86ccaf5dd121 b582c1a2-cdc3-4d5e-9530-98ec948b73e0 1f539d35-3bbc-4f90-aaff-10d3032ef2b0 e2de8661-6803-4804-af22-dfb8e266bf28 9ce41eb7-ec2b-4324-aa02-25f1b56a227c ee3de342-75a9-4ba9-8657-a096717d0bf7 0dbbd193-38d2-4e19-9e17-7a64846e9940 6244b430-52c4-4ce9-94f4-e4db2aff31ef";
        query = "((((gDocCollectionID == \"14c1decd-347f-4783-81be-53119af7acf1\") and (gDocCollectionLang == \"en\"))) and (allIndexes = a*)) project *";
        try {
            QuerySnippetTermsPair luceneQuery = ((LuceneGcqlQueryContainer)new LuceneGcqlProcessor().processQuery(presentable, searchable, query, null)).getLuceneQuery();
            System.out.println(luceneQuery.query);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public GcqlQueryContainer processQuery(ArrayList<String> presentableFields, ArrayList<String> searchableFields, String gCQLQuery, RRadaptor adaptor) throws Exception {
        this.presentableFields = presentableFields;
        this.searchableFields = searchableFields;
        this.adaptor = adaptor;
        logger.trace((Object)("Number of Presentable Fields: " + this.presentableFields.size() + ", Number of Searchable Fields: " + this.searchableFields.size()));
        logger.trace((Object)("Presentable Fields: " + this.presentableFields + ", Searchable Fields: " + this.searchableFields));
        logger.trace((Object)("CQL query: " + gCQLQuery));
        GCQLNode head = GCQLQueryTreeManager.parseGCQLString((String)gCQLQuery);
        QuerySnippetTermsPair querySnippetTerms = this.processNode(head);
        logger.trace((Object)("Processed Lucene query: " + querySnippetTerms.query));
        logger.trace((Object)("Processed snippet Terms: " + querySnippetTerms.snippetTerms.toString()));
        return new LuceneGcqlQueryContainer(querySnippetTerms, this.projectedFields);
    }

    public GcqlQueryContainer processQuery(ArrayList<String> presentableFields, ArrayList<String> searchableFields, String gCQLQuery) throws Exception {
        return this.processQuery(presentableFields, searchableFields, null);
    }

    private QuerySnippetTermsPair processNode(GCQLNode node) throws Exception {
        if (node instanceof GCQLProjectNode) {
            return this.processNode((GCQLProjectNode)node);
        }
        if (node instanceof GCQLAndNode) {
            return this.processNode((GCQLAndNode)node);
        }
        if (node instanceof GCQLNotNode) {
            return this.processNode((GCQLNotNode)node);
        }
        if (node instanceof GCQLOrNode) {
            return this.processNode((GCQLOrNode)node);
        }
        if (node instanceof GCQLTermNode) {
            return this.processNode((GCQLTermNode)node);
        }
        throw new Exception("This node class is not supported: " + node.getClass().toString());
    }

    private QuerySnippetTermsPair processNode(GCQLProjectNode node) throws Exception {
        Vector projections = node.getProjectIndexes();
        for (ModifierSet projection : projections) {
            if (projection.getBase().equals("*")) {
                this.projectedFields.clear();
                this.projectedFields.put("*", "*");
                return this.processNode(node.subtree);
            }
            String fieldLabel = null;
            fieldLabel = this.adaptor != null ? this.adaptor.getFieldNameById(projection.getBase()) : projection.getBase();
            String projField = this.findPresentable(fieldLabel);
            if (projField == null) {
                logger.error((Object)("Projection: " + fieldLabel + ", " + projection.getBase() + "is not part of the presentable fields : " + this.presentableFields));
                continue;
            }
            this.projectedFields.put(projection.getBase(), projField);
        }
        return this.processNode(node.subtree);
    }

    private QuerySnippetTermsPair processNode(GCQLAndNode node) throws Exception {
        QuerySnippetTermsPair left = this.processNode(node.left);
        QuerySnippetTermsPair right = this.processNode(node.right);
        QuerySnippetTermsPair result = new QuerySnippetTermsPair();
        result.snippetTerms = this.mergeSnippetTerms(left.snippetTerms, right.snippetTerms);
        result.snippetNotTerms = this.mergeSnippetTerms(left.snippetNotTerms, right.snippetNotTerms);
        result.query = "( " + left.query + LUCENE_AND + right.query + " )";
        return result;
    }

    private HashMap<String, ArrayList<String>> mergeSnippetTerms(HashMap<String, ArrayList<String>> left, HashMap<String, ArrayList<String>> right) {
        for (Map.Entry<String, ArrayList<String>> current : right.entrySet()) {
            ArrayList<String> terms = left.get(current.getKey());
            if (terms == null) {
                left.put(current.getKey(), current.getValue());
                continue;
            }
            terms.addAll((Collection<String>)current.getValue());
        }
        return left;
    }

    private QuerySnippetTermsPair processNode(GCQLOrNode node) throws Exception {
        QuerySnippetTermsPair left = this.processNode(node.left);
        QuerySnippetTermsPair right = this.processNode(node.right);
        QuerySnippetTermsPair result = new QuerySnippetTermsPair();
        result.snippetTerms = this.mergeSnippetTerms(left.snippetTerms, right.snippetTerms);
        result.snippetNotTerms = this.mergeSnippetTerms(left.snippetNotTerms, right.snippetNotTerms);
        result.query = "( " + left.query + LUCENE_OR + right.query + " )";
        return result;
    }

    private QuerySnippetTermsPair processNode(GCQLNotNode node) throws Exception {
        QuerySnippetTermsPair left = this.processNode(node.left);
        QuerySnippetTermsPair right = this.processNode(node.right);
        QuerySnippetTermsPair result = new QuerySnippetTermsPair();
        result.snippetTerms = this.mergeSnippetTerms(left.snippetTerms, right.snippetNotTerms);
        result.snippetNotTerms = this.mergeSnippetTerms(left.snippetNotTerms, right.snippetTerms);
        result.query = "( " + left.query + LUCENE_NOT + right.query + " )";
        return result;
    }

    private QuerySnippetTermsPair processNode(GCQLTermNode node) throws Exception {
        boolean found = false;
        boolean allFields = false;
        String index = null;
        QuerySnippetTermsPair result = new QuerySnippetTermsPair();
        if (node.getIndex().equals("gDocCollectionID") || node.getIndex().equals("gDocCollectionLang")) {
            node.getRelation().setBase(LuceneSearcher.SupportedRelations.adj.toString());
            index = node.getIndex();
            found = true;
        } else {
            String fieldLabel = null;
            fieldLabel = this.adaptor != null ? this.adaptor.getFieldNameById(node.getIndex()) : node.getIndex();
            if (fieldLabel.equalsIgnoreCase("allIndexes")) {
                allFields = true;
                found = true;
            } else {
                for (String field : this.searchableFields) {
                    if (!fieldLabel.equalsIgnoreCase(field)) continue;
                    index = field;
                    found = true;
                    break;
                }
            }
        }
        if (!found) {
            throw new Exception("Field: " + node.getIndex() + ", is not part of the searchable fields");
        }
        if (node.getRelation().getBase().equals("=")) {
            node.getRelation().setBase(LuceneSearcher.SupportedRelations.adj.toString());
        }
        StringBuffer luceneBuf = new StringBuffer();
        String processedTerm = null;
        ArrayList<String> snippetTerms = new ArrayList<String>();
        found = false;
        for (LuceneSearcher.SupportedRelations relation : LuceneSearcher.SupportedRelations.values()) {
            if (!node.getRelation().getBase().equalsIgnoreCase(relation.toString())) continue;
            switch (relation) {
                case adj: {
                    processedTerm = node.getTerm();
                    snippetTerms.add(processedTerm);
                    break;
                }
                case fuzzy: {
                    String[] terms = LuceneGcqlProcessor.splitTerms(node.getTerm());
                    if (terms.length > 1) {
                        throw new Exception("The fuzzy relation must have only one term. Received: " + node.getTerm());
                    }
                    processedTerm = terms[0].trim() + "~";
                    snippetTerms.add(terms[0].trim());
                    break;
                }
                case proximity: {
                    String[] terms = LuceneGcqlProcessor.splitTerms(node.getTerm());
                    if (terms.length < 3) {
                        throw new Exception("The proximity relation must have at least three terms. Received: " + node.getTerm());
                    }
                    int distance = 0;
                    try {
                        distance = Integer.parseInt(terms[0]);
                    }
                    catch (NumberFormatException e) {
                        throw new Exception("Wrong syntax for proximity relation. Term 0 was: " + terms[0], e);
                    }
                    StringBuffer buf = new StringBuffer();
                    for (int i = 1; i < terms.length; ++i) {
                        buf.append(terms[i] + " ");
                        snippetTerms.add(terms[i]);
                    }
                    processedTerm = "\"" + buf.toString().trim() + "\"~" + distance;
                    break;
                }
                case within: {
                    String[] terms = LuceneGcqlProcessor.splitTerms(node.getTerm());
                    if (terms.length != 2) {
                        throw new Exception("The within relation must have exact two terms. Received: " + node.getTerm());
                    }
                    processedTerm = "[" + terms[0] + " TO " + terms[1] + "]";
                    snippetTerms.add(terms[0]);
                    snippetTerms.add(terms[1]);
                    break;
                }
                default: {
                    throw new Exception("Possible bug. Relation: " + (Object)((Object)relation) + " is reported to be supported but it is not handled here");
                }
            }
            found = true;
            break;
        }
        if (!found) {
            throw new Exception("Relation: " + node.getRelation().getBase() + " is not supported");
        }
        if (allFields) {
            boolean first = true;
            luceneBuf.append(processedTerm);
            for (String field : this.searchableFields) {
                if (field.equals("gDocCollectionID") || field.equals("gDocCollectionLang") || field.equals("ObjectID") || field.equals("allIndexes")) continue;
                result.snippetTerms.put(field, (ArrayList)snippetTerms.clone());
            }
            snippetTerms = null;
        } else {
            luceneBuf.append(index + ":" + processedTerm);
            if (!index.equals("gDocCollectionID") && !index.equals("gDocCollectionLang")) {
                result.snippetTerms.put(index, snippetTerms);
            }
        }
        logger.debug((Object)("Term Node result: " + luceneBuf.toString()));
        result.query = "( " + luceneBuf.toString() + " )";
        return result;
    }
}

