/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.common.linguistics.lemmatizerplugin;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.indexmanagement.common.IndexException;
import org.gcube.indexmanagement.common.linguistics.lemmatizerplugin.DummyLemmatizerPlugin;
import org.gcube.indexmanagement.common.linguistics.lemmatizerplugin.Language;
import org.gcube.indexmanagement.common.linguistics.lemmatizerplugin.LemmatizerFactory;
import org.gcube.indexmanagement.common.linguistics.lemmatizerplugin.LemmatizerPlugin;
import org.tartarus.snowball.SnowballProgram;
import org.tartarus.snowball.ext.EnglishStemmer;
import org.tartarus.snowball.ext.FrenchStemmer;
import org.tartarus.snowball.ext.GermanStemmer;
import org.tartarus.snowball.ext.ItalianStemmer;
import org.tartarus.snowball.ext.SpanishStemmer;

public class SnowballStemmingPlugin
implements LemmatizerPlugin {
    static GCUBELog logger = new GCUBELog(DummyLemmatizerPlugin.class);
    Map<String, SnowballProgram> Stemmer = new HashMap<String, SnowballProgram>();

    @Override
    public void init(String configFile, Vector<Language> languages) throws IndexException {
        try {
            logger.info((Object)"Initializing Sowball plugin");
            for (Language l : languages) {
                String lang = new String(l.toString());
                if (lang.equalsIgnoreCase("en")) {
                    this.Stemmer.put(lang, (SnowballProgram)new EnglishStemmer());
                }
                if (lang.equalsIgnoreCase("es")) {
                    this.Stemmer.put(lang, (SnowballProgram)new SpanishStemmer());
                }
                if (lang.equalsIgnoreCase("it")) {
                    this.Stemmer.put(lang, (SnowballProgram)new ItalianStemmer());
                }
                if (lang.equalsIgnoreCase("de")) {
                    this.Stemmer.put(lang, (SnowballProgram)new GermanStemmer());
                }
                if (lang.equalsIgnoreCase("de")) {
                    this.Stemmer.put(lang, (SnowballProgram)new GermanStemmer());
                }
                if (!lang.equalsIgnoreCase("fr")) continue;
                this.Stemmer.put(lang, (SnowballProgram)new FrenchStemmer());
            }
            return;
        }
        catch (NoSuchElementException e) {
            throw new IndexException("Language iterator failed " + e.toString());
        }
        catch (ClassCastException e) {
            throw new IndexException("Language cast exception" + e.toString());
        }
        catch (Exception e) {
            throw new IndexException("Error creating language_identifier with config: " + configFile + " " + e.toString());
        }
    }

    @Override
    public String lemmatize_word(String word, Language language) throws IndexException {
        try {
            SnowballProgram stemer = this.Stemmer.get(language.toString());
            stemer.setCurrent(word);
            stemer.stem();
            return stemer.getCurrent() + "*";
        }
        catch (Exception ex) {
            throw new IndexException("SnowballStemmingPlugin lemmatize_word failed " + ex.toString());
        }
    }

    @Override
    public String lemmatize_string(String document, Language language) throws IndexException {
        try {
            return "";
        }
        catch (Exception ex) {
            throw new IndexException("DummyLemmatizerPlugin::lemmatize_word failed " + ex.toString());
        }
    }

    @Override
    public void add_language(Language language) throws IndexException {
    }

    public static void main(String[] args) {
        try {
            String pluginName = "org.gcube.indexmanagement.common.linguistics.lemmatizerplugin.SnowballStemmingPlugin";
            String configFilePath = "/ld/work/diligent/daacvs/indexservice/linguistics/fastlinguistics/fastlemmatizer/etc/LemmatizationConfigQueryExpansion.xml";
            logger.info((Object)("Loading plugin using factory, config file: " + configFilePath));
            Vector<Language> languages = new Vector<Language>();
            LemmatizerPlugin lepl = null;
            lepl = LemmatizerFactory.loadPlugin(pluginName);
            try {
                languages.add(Language.en);
                languages.add(Language.it);
                languages.add(Language.fr);
                languages.add(Language.es);
                languages.add(Language.sv);
                languages.add(Language.af);
                lepl.init(configFilePath, languages);
            }
            catch (IndexException e) {
                logger.warn((Object)"**** Got exception for languages", (Throwable)e);
            }
            logger.info((Object)"L E M M A T I Z I N G");
            String input = "house";
            logger.info((Object)("Lemmatize: " + Language.en.toLongString() + " house " + " lemmatized form " + lepl.lemmatize_word(input, Language.en)));
            logger.info((Object)("Lemmatize: " + Language.fr.toLongString() + " maison " + " lemmatized form " + lepl.lemmatize_word("maison", Language.fr)));
            logger.info((Object)("Lemmatize: " + Language.it.toLongString() + " casa " + " lemmatized form " + lepl.lemmatize_word("casa", Language.it)));
            logger.info((Object)(" Adding language: " + Language.pt.toLongString()));
            try {
                lepl.add_language(Language.pt);
            }
            catch (IndexException e) {
                logger.warn((Object)"**** Got exception for languages", (Throwable)e);
            }
            logger.info((Object)(" Adding language: " + Language.en.toLongString()));
            try {
                lepl.add_language(Language.en);
            }
            catch (IndexException e) {
                logger.warn((Object)"**** Got exception for languages", (Throwable)e);
            }
            input = "house maison case knee hus casa knife ceasare ";
            logger.info((Object)("Lemmatize: " + Language.en.toLongString() + " " + input + " lemmatized form " + lepl.lemmatize_string(input, Language.en)));
            logger.info((Object)("Lemmatize: " + Language.fr.toLongString() + " " + input + " lemmatized form " + lepl.lemmatize_string(input, Language.fr)));
            logger.info((Object)("Lemmatize: " + Language.it.toLongString() + " " + input + " lemmatized form " + lepl.lemmatize_string(input, Language.it)));
            logger.info((Object)("Lemmatize: " + Language.pt.toLongString() + " " + input + " lemmatized form " + lepl.lemmatize_string(input, Language.pt)));
            logger.info((Object)("Lemmatize: " + Language.es.toLongString() + " " + input + " lemmatized form " + lepl.lemmatize_string(input, Language.es)));
        }
        catch (IndexException ie) {
            logger.error((Object)"Error during lemmatization.", (Throwable)ie);
        }
    }
}

