/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.common;

import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.indexmanagement.common.ForwardIndexField;
import org.gcube.indexmanagement.common.IndexType;
import org.gcube.indexmanagement.common.XMLProfileParser;

public class ForwardIndexType
extends IndexType {
    static GCUBELog logger = new GCUBELog(ForwardIndexType.class);
    private static final String KEY_FIELD_NAME = "key";
    private static final String VALUE_FIELD_NAME = "value";
    public ForwardIndexField[] fields;
    private XMLProfileParser parser = null;
    private ForwardIndexField keyField = null;
    private ForwardIndexField valueField = null;

    public ForwardIndexType(String indexTypeName, String scopeStr) {
        super(indexTypeName);
        GCUBEScope scope = GCUBEScope.getScope((String)scopeStr);
        try {
            String indexType = this.retrieveIndexTypeGenericResource(scope);
            if (this.parser == null) {
                this.parser = new XMLProfileParser();
            }
            this.parser.readString(indexType, null);
            this.readIndexType();
        }
        catch (Exception ex) {
            logger.error((Object)"Error initializing ForwardIndexType.", (Throwable)ex);
        }
    }

    private void readIndexType() throws Exception {
        int position = 0;
        try {
            this.parser.setRootNode("field-list");
            int nrOfFields = this.parser.countDescendants("field");
            if (nrOfFields != 2) {
                throw new Exception("Invalid forward index type: number of fields must be equal to 2.");
            }
            this.fields = new ForwardIndexField[nrOfFields];
            while (this.parser.setNextField()) {
                this.fillField(position++);
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error while reading indexType, position: " + position), (Throwable)ex);
            throw ex;
        }
    }

    private void fillField(int position) throws Exception {
        this.fields[position] = new ForwardIndexField();
        this.fields[position].name = this.parser.getFieldByValue("name");
        this.fields[position].dataType = ForwardIndexField.DataType.getByName(this.parser.getFieldByValue("type"));
        this.fields[position].size = this.fields[position].dataType.getDefaultSize();
        this.fields[position].dataTypeFormat = this.parser.getFieldByValue("format");
        if (this.fields[position].name.equals(KEY_FIELD_NAME)) {
            this.keyField = this.fields[position];
        } else if (this.fields[position].name.equals(VALUE_FIELD_NAME)) {
            this.valueField = this.fields[position];
        } else {
            throw new Exception("Unrecongisable field found: " + this.fields[position].name);
        }
    }

    public boolean containsField(String fieldName, ForwardIndexField.DataType fieldDataType) {
        for (ForwardIndexField field : this.fields) {
            if (!field.name.equals(fieldName) || !field.dataType.equals((Object)fieldDataType)) continue;
            return true;
        }
        return false;
    }

    public ForwardIndexField getKeyField() {
        return this.keyField;
    }

    public ForwardIndexField getValueField() {
        return this.valueField;
    }
}

