/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.geo.shape;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.geom.Rectangle2D;

public class Rectangle {
    private long minX;
    private long maxX;
    private long minY;
    private long maxY;

    public Rectangle(long x1, long x2, long y1, long y2) {
        this.minX = Math.min(x1, x2);
        this.maxX = Math.max(x1, x2);
        this.minY = Math.min(y1, y2);
        this.maxY = Math.max(y1, y2);
    }

    public Rectangle(Envelope e) {
        this.minX = new Double(e.getMinX()).longValue();
        this.maxX = new Double(e.getMaxX()).longValue();
        this.minY = new Double(e.getMinY()).longValue();
        this.maxY = new Double(e.getMaxY()).longValue();
    }

    public long getMinX() {
        return this.minX;
    }

    public long getMaxX() {
        return this.maxX;
    }

    public long getMinY() {
        return this.minY;
    }

    public long getMaxY() {
        return this.maxY;
    }

    public boolean contains(Rectangle r) {
        return this.maxX >= r.getMaxX() && this.maxY >= r.getMaxY() && this.minX <= r.getMinX() && this.minY <= r.getMinY();
    }

    public boolean containsPoint(long x, long y) {
        return x >= this.minX && x <= this.maxX && y >= this.minY && y <= this.maxY;
    }

    public boolean overlaps(Rectangle r) {
        return this.containsPoint(r.getMinX(), r.getMinY()) || this.containsPoint(r.getMinX(), r.getMaxY()) || this.containsPoint(r.getMaxX(), r.getMinY()) || this.containsPoint(r.getMaxX(), r.getMaxY()) || r.contains(this);
    }

    private Rectangle2D getRectangle2D() {
        return new Rectangle2D.Double(this.minX, this.minY, this.maxX - this.minX, this.maxY - this.minY);
    }

    public String toString() {
        return new StringBuffer().append("Rect[x1: ").append(this.minX).append(" x2: ").append(this.maxX).append(" | y1: ").append(this.minY).append(" y2: ").append(this.maxY).append("]").toString();
    }
}

