package org.gcube.indexmanagement.featureindexlibrary.vafile;

import org.gcube.indexmanagement.featureindexlibrary.commons.FIEnums;

/**
 * VAFile Header info 
 * 
 * @author UoA
 */
public class VAFileParams {
	/**
	 * The feature indexed
	 */
	private String feature=null;
	/**
	 * The default distance
	 */
	private FIEnums.DistanceTypes distance=null;
	/**
	 * The index id
	 */
	private String indexID=null;
	/**
	 * The storage
	 */
	private String storage=null;
	/**
	 * The index name
	 */
	private String indexName=null;
	/**
	 * The element count
	 */
	private long elementCount=0;
	/**
	 * The bits to use for each dimention
	 */
	private short bits=0;
	/**
	 * The length of the id
	 */
	private int IDLength=0;
	/**
	 * The length of the vector
	 */
	private int vectorLength=0;
	/**
	 * The buckets
	 */
	private int buckets=0;
	/**
	 * The points in each dimention that act as partitions
	 */
	private float [][]partitionPoints=null;
	/**
	 * Used for standard deviation calculation
	 */
	private float []xsum=null;
	/**
	 * Used for standard deviation calculation
	 */
	private float []x2sum=null;
	/**
	 * Weigths per dimention
	 */
	private float []weights=null;
	/**
	 * The length of the approximation entries
	 */
	private long approximationEntryLength=0;
	/**
	 * The length of each entry in the vector file
	 */
	private long vectorEntryLength=0;
	/**
	 * Default usage of weights
	 */
	private boolean weighted=true;
	
	/**
	 * Creates a new instance
	 */
	public VAFileParams(){}
	
	/**
	 * Creates a new instance
	 * 
	 * @param feature The feature
	 * @param distance The default distance measure
	 * @param indexID the index id
	 * @param storage the storage location
	 * @param indexName The index name
	 * @param bits The bits 
	 * @param IDLength The length of the ids
	 * @param vectorLength The length of the vectors 
	 * @param weighted Default usage of weights
	 */
	public VAFileParams(String feature,FIEnums.DistanceTypes distance,String indexID,String storage,String indexName,short bits,int IDLength,int vectorLength,boolean weighted){
		this.feature=feature;
		this.distance=distance;
		this.indexID=indexID;
		this.storage=storage;
		this.indexName=indexName;
		this.elementCount=0;
		this.bits=bits;
//		this.bits=8;
		this.IDLength=IDLength;
		this.vectorLength=vectorLength;
		this.x2sum=new float[vectorLength];
		this.xsum=new float[vectorLength];
		this.weights=new float[vectorLength];
		this.weighted=weighted;
		for(int i=0;i<vectorLength;i+=1){
			this.xsum[i]=0;
			this.x2sum[i]=0;
		}
	}
	
	/**
	 * Property setter
	 * 
	 * @param approximationEntryLength the value to set
	 */
	public void setApproximationEntryLength(long approximationEntryLength){
		this.approximationEntryLength=approximationEntryLength;
	}
	
	/**
	 * Property getter 
	 * 
	 * @return Teh property value
	 */
	public long getApproximationEntryLength(){
		return this.approximationEntryLength;
	}

	/**
	 * Property setter
	 * 
	 * @param vectorEntryLength the value to set
	 */
	public void setVectorEntryLength(long vectorEntryLength){
		this.vectorEntryLength=vectorEntryLength;
	}
	
	/**
	 * Property getter 
	 * 
	 * @return Teh property value
	 */
	public long getVectorEntryLength(){
		return this.vectorEntryLength;
	}
	
	/**
	 * Property setter
	 * 
	 * @param xsum the value to set
	 */
	public void setXSum(float []xsum){
		this.xsum=xsum;
	}
	
	/**
	 * Property getter 
	 * 
	 * @return Teh property value
	 */
	public float []getXSum(){
		return this.xsum;
	}

	/**
	 * Property setter
	 * 
	 * @param x2sum the value to set
	 */
	public void setX2Sum(float []x2sum){
		this.x2sum=x2sum;
	}
	
	/**
	 * Property getter 
	 * 
	 * @return Teh property value
	 */
	public float []getX2Sum(){
		return this.x2sum;
	}

	/**
	 * Property setter
	 * 
	 * @param weights the value to set
	 */
	public void setWeights(float []weights){
		this.weights=weights;
	}
	
	/**
	 * Property getter 
	 * 
	 * @return Teh property value
	 */
	public float []getWeights(){
		return this.weights;
	}
	
	/**
	 * Property setter
	 * 
	 * @param weighted the value to set
	 */
	public void setWeighted(boolean weighted){
		this.weighted=weighted;
	}
	
	/**
	 * Property getter 
	 * 
	 * @return Teh property value
	 */
	public boolean getWeighted(){
		return this.weighted;
	}

	/**
	 * Property setter
	 * 
	 * @param partitionPoints the value to set
	 */
	public void setPartitionPoints(float [][]partitionPoints){
		this.partitionPoints=partitionPoints;
	}
	
	/**
	 * Property getter 
	 * 
	 * @return Teh property value
	 */
	public float [][]getPartitionPoints(){
		return this.partitionPoints;
	}

	/**
	 * Property setter
	 * 
	 * @param buckets the value to set
	 */
	public void setBuckets(int buckets){
		this.buckets=buckets;
	}
	
	/**
	 * Property getter 
	 * 
	 * @return Teh property value
	 */
	public int getBuckets(){
		return this.buckets;
	}

	/**
	 * Property getter 
	 * 
	 * @return Teh property value
	 */
	public short getBits() {
		return bits;
	}

	/**
	 * Property setter
	 * 
	 * @param bits the value to set
	 */
	public void setBits(short bits) {
		this.bits = bits;
//		this.bits=8;
	}

	/**
	 * Property getter 
	 * 
	 * @return Teh property value
	 */
	public FIEnums.DistanceTypes getDistanceMeasure() {
		return distance;
	}

	/**
	 * Property setter
	 * 
	 * @param distanceMeasure the value to set
	 */
	public void setDistanceMeasure(FIEnums.DistanceTypes distanceMeasure) {
		this.distance = distanceMeasure;
	}

	/**
	 * Property getter 
	 * 
	 * @return Teh property value
	 */
	public long getElementCount() {
		return elementCount;
	}

	/**
	 * Property setter
	 * 
	 * @param elementCount the value to set
	 */
	public void setElementCount(long elementCount) {
		this.elementCount = elementCount;
	}

	/**
	 * Property getter 
	 * 
	 * @return Teh property value
	 */
	public String getFeatureName() {
		return feature;
	}

	/**
	 * Property setter
	 * 
	 * @param featureName the value to set
	 */
	public void setFeatureName(String featureName) {
		this.feature = featureName;
	}

	/**
	 * Property getter 
	 * 
	 * @return Teh property value
	 */
	public String getIndexID() {
		return indexID;
	}

	/**
	 * Property setter
	 * 
	 * @param indexID the value to set
	 */
	public void setIndexID(String indexID) {
		this.indexID = indexID;
	}

	/**
	 * Property getter 
	 * 
	 * @return Teh property value
	 */
	public String getIndexName() {
		return indexName;
	}

	/**
	 * Property setter
	 * 
	 * @param indexName the value to set
	 */
	public void setIndexName(String indexName) {
		this.indexName = indexName;
	}

	/**
	 * Property getter 
	 * 
	 * @return Teh property value
	 */
	public String getStorage() {
		return storage;
	}

	/**
	 * Property setter
	 * 
	 * @param storage the value to set
	 */
	public void setStorage(String storage) {
		this.storage = storage;
	}

	/**
	 * Property getter 
	 * 
	 * @return Teh property value
	 */
	public int getIDLength() {
		return IDLength;
	}

	/**
	 * Property setter
	 * 
	 * @param length the value to set
	 */
	public void setIDLength(int length) {
		IDLength = length;
	}

	/**
	 * Property getter 
	 * 
	 * @return Teh property value
	 */
	public int getVectorLength() {
		return vectorLength;
	}

	/**
	 * Property setter
	 * 
	 * @param vectorLength the value to set
	 */
	public void setVectorLength(int vectorLength) {
		this.vectorLength = vectorLength;
	}
}
