package org.gcube.indexmanagement.featureindexlibrary.vafile.algo;

import org.apache.log4j.Logger;

/**
 * Computes the lower and upper bounds of the query point to all grid cells
 * 
 * @author UoA
 */
public class ComputeBoundsLU{
	/**
	 * The Logger used by the class
	 */
	private static Logger log = Logger.getLogger(ComputeBoundsLU.class);
	/**
	 * The partition points
	 */
	private float [][]partitionPoints=null;
	/**
	 * The buckets in each dimention
	 */
	private int buckets=0;
	/**
	 * The lower distance differences
	 */
	private float [][]dLow=null;
	/**
	 * The upper distance differences
	 */
	private float [][]dHigh=null;
	
	/**
	 * Creates a new instance
	 * 
	 * @param partitionPoints Teh partition points
	 * @param buckets The buckets
	 */
	public ComputeBoundsLU(float [][]partitionPoints, int buckets){
		this.partitionPoints=partitionPoints;
		this.buckets=buckets;
		dLow=new float[partitionPoints.length][buckets-1];
		dHigh=new float[partitionPoints.length][buckets-1];
	}
	
	/**
	 * Teh lower bound of the bit string
	 * 
	 * @param bitString The bit string
	 * @return The lower bound
	 */
	public float getLowerBound(byte []bitString){
		float bound=0;
		for(int i=0;i<bitString.length;i+=1){
			bound+=this.dLow[i][(int)bitString[i]];
		}
		return bound;
	}
	
	/**
	 * The upper bound of the bit string
	 * 
	 * @param bitString The bit string
	 * @return The upper bound
	 */
	public float getUpperBound(byte []bitString){
		float bound=0;
		for(int i=0;i<bitString.length;i+=1){
			bound+=this.dHigh[i][(int)bitString[i]];
		}
		return bound;
	}
	
	/**
	 * precompute the upper lower distance differences for the query vector 
	 * 
	 * @param vector The query vector
	 * @throws Exception An error
	 */
	public void preCompute(float []vector) throws Exception{
		try{
			for(int j=0;j<partitionPoints.length;j+=1){
				for(int i=0;i<buckets-1;i+=1){
	//				if(vector[j]<this.getFloor(j,(byte)i)){
					if(vector[j]<this.getFloor(j,i)){
	//					dLow[j][i]=(this.getFloor(j,(byte)i)-vector[j])*(this.getFloor(j,(byte)i)-vector[j]);
						dLow[j][i]=(this.getFloor(j,i)-vector[j])*(this.getFloor(j,i)-vector[j]);
					}
					else if(vector[j]>this.getCeiling(j,(byte)i)){
	//					dLow[j][i]=(vector[j]-this.getCeiling(j,(byte)i))*(vector[j]-this.getCeiling(j,(byte)i));
						dLow[j][i]=(vector[j]-this.getCeiling(j,i))*(vector[j]-this.getCeiling(j,i));
					}
					else{
						dLow[j][i]=0;
					}
	//				if(vector[j]<=((this.getFloor(j,(byte)i)+this.getCeiling(j,(byte)i))/(float)2)){
					if(vector[j]<=((this.getFloor(j,i)+this.getCeiling(j,i))/(float)2)){
	//					dHigh[j][i]=(this.getCeiling(j,(byte)i)-vector[j])*(this.getCeiling(j,(byte)i)-vector[j]);
						dHigh[j][i]=(this.getCeiling(j,i)-vector[j])*(this.getCeiling(j,i)-vector[j]);
					}
					else{
	//					dHigh[j][i]=(vector[j]-this.getFloor(j,(byte)i))*(vector[j]-this.getFloor(j,(byte)i));
						dHigh[j][i]=(vector[j]-this.getFloor(j,i))*(vector[j]-this.getFloor(j,i));
					}
				}
			}
		}catch(Exception e){
			log.error("Could not compute Dbounds for query. Throwing Exception",e);
			throw new Exception("Could not compute Dbounds for query");
		}
//		this.dBounds=new BoundDistances(Dlow,Dhigh);
	}
	
//	private float getFloor(int dim,byte bitString){
	/**
	 * The floor partition point in the given dimention
	 * 
	 * @param dim The dimention 
	 * @param bitString the bit string
	 * @return the floor partition point
	 */
	private float getFloor(int dim,int bitString){
		return partitionPoints[dim][((int)bitString)];
	}

//	private float getCeiling(int dim,byte bitString){
	/**
	 * The ceiling partition point in the given dimention
	 * 
	 * @param dim The dimention 
	 * @param bitString the bit string
	 * @return the ceiling partition point
	 */
	private float getCeiling(int dim,int bitString){
		return partitionPoints[dim][((int)bitString)+1];
	}
}
