/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.geo;

import java.util.HashMap;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.indexmanagement.common.IndexType;
import org.gcube.indexmanagement.common.XMLProfileParser;
import org.gcube.indexmanagement.geo.GeoIndexField;

public class GeoIndexType
extends IndexType {
    static GCUBELog logger = new GCUBELog(GeoIndexType.class);
    public GeoIndexField[] fields;
    private HashMap<String, Integer> fieldIndexMap;
    public int nrOfFields;
    public int size = 0;
    private XMLProfileParser parser = null;

    public GeoIndexType(String indexTypeName, GCUBEScope scope) {
        super(indexTypeName);
        try {
            String indexType = this.retrieveIndexTypeGenericResource(scope);
            this.fieldIndexMap = new HashMap();
            if (this.parser == null) {
                this.parser = new XMLProfileParser();
            }
            this.parser.readString(indexType, null);
            this.readIndexType();
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to initialize GeoIndexType.", (Throwable)ex);
        }
    }

    private void readIndexType() throws Exception {
        int position = 0;
        try {
            this.parser.setRootNode("field-list");
            this.nrOfFields = this.parser.countDescendants("field");
            this.fields = new GeoIndexField[this.nrOfFields];
            while (this.parser.setNextField()) {
                this.fillField(position++);
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error while reading indexType, position: " + position), (Throwable)ex);
            throw ex;
        }
    }

    private void fillField(int position) throws Exception {
        String sizeString;
        this.fields[position] = new GeoIndexField();
        this.fields[position].name = this.parser.getFieldByValue("name");
        this.fields[position].dataType = GeoIndexField.DataType.getByName(this.parser.getFieldByValue("type"));
        this.fields[position].size = this.fields[position].dataType.equals((Object)GeoIndexField.DataType.STRING) && (sizeString = this.parser.getFieldByValue("size")).length() > 0 ? Integer.parseInt(sizeString) : this.fields[position].dataType.getDefaultSize();
        this.fields[position].isReturnable = this.parser.getFieldByValue("return").equalsIgnoreCase("yes");
        this.fields[position].isVariable = this.parser.getFieldByValue("variable").equalsIgnoreCase("yes");
        this.size += this.fields[position].size;
        this.fieldIndexMap.put(this.fields[position].name, position);
    }

    public boolean containsField(String fieldName, GeoIndexField.DataType fieldDataType) {
        for (GeoIndexField field : this.fields) {
            if (!field.name.equals(fieldName) || !field.dataType.equals((Object)fieldDataType)) continue;
            return true;
        }
        return false;
    }

    public Integer getFieldPosition(String fieldName) {
        return this.fieldIndexMap.get(fieldName);
    }

    public String toString() {
        String ret = "IndexType: \nid=tempID\nnrOfFields=" + this.nrOfFields + "\n";
        for (int i = 0; i < this.nrOfFields; ++i) {
            ret = ret + this.fields[i] + "\n";
        }
        return ret;
    }
}

