package org.gcube.indexmanagement.featureindexlibrary.merger;

import java.util.ArrayList;

import org.gcube.indexmanagement.featureindexlibrary.commons.RankedResultElement;

/**
 * Element holding results and their respective weights 
 * 
 * @author UoA
 */
public class RankedMergeElement {
	/**
	 * The results
	 */
	private ArrayList<RankedResultElement> results=null;
	/**
	 * The weigth
	 */
	private float weight=1; 
	
	/**
	 * Creates a new instance
	 * 
	 * @param results The results
	 * @param weight The weight
	 */
	public RankedMergeElement(ArrayList<RankedResultElement> results,float weight){
		this.results=results;
		this.weight=weight;
	}

	/**
	 * Retrieves teh results
	 * 
	 * @return The results
	 */
	public ArrayList<RankedResultElement> getResults() {
		return results;
	}

	/**
	 * Sets the results
	 * 
	 * @param results The results
	 */
	public void setResults(ArrayList<RankedResultElement> results) {
		this.results = results;
	}

	/**
	 * Retrieves the weights
	 * 
	 * @return The weights
	 */
	public float getWeight() {
		return weight;
	}

	/**
	 * Sets the weight
	 * 
	 * @param weight The weight
	 */
	public void setWeight(float weight) {
		this.weight = weight;
	}
}
