/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.featureindexlibrary.vafile.algo;

import java.io.RandomAccessFile;
import org.apache.log4j.Logger;
import org.gcube.indexmanagement.featureindexlibrary.commons.FeatureVectorElement;
import org.gcube.indexmanagement.featureindexlibrary.commons.FileHelper;
import org.gcube.indexmanagement.featureindexlibrary.vafile.VAFileParams;
import org.gcube.indexmanagement.featureindexlibrary.vafile.algo.ApproximationGenerator;
import org.gcube.indexmanagement.featureindexlibrary.vafile.elements.ApproximationFileEntry;
import org.gcube.indexmanagement.featureindexlibrary.vafile.elements.VectorFileEntry;
import org.gcube.indexmanagement.featureindexlibrary.vafile.io.FileBufferReader;
import org.gcube.indexmanagement.featureindexlibrary.vafile.io.IOHelper;

public class PopulateIndex {
    private static Logger logger = Logger.getLogger(PopulateIndex.class);
    private VAFileParams params = null;
    private boolean first = true;
    private RandomAccessFile vrand = null;
    private RandomAccessFile arand = null;
    private IOHelper helper = null;

    public PopulateIndex(VAFileParams params, boolean firstcreated) throws Exception {
        try {
            this.params = params;
            this.first = firstcreated;
            this.helper = new IOHelper();
            this.helper.setIDLength(params.getIDLength());
            this.helper.setVectorLength(params.getVectorLength());
        }
        catch (Exception e) {
            logger.error((Object)"Could not initialize index population. throwing Exception", (Throwable)e);
            throw new Exception("Could not initialize index population");
        }
    }

    public void open() throws Exception {
        try {
            this.vrand = new RandomAccessFile(FileHelper.getVAFVectorFile(this.params.getStorage(), this.params.getIndexID()), "rw");
            this.arand = new RandomAccessFile(FileHelper.getVAFApproxFile(this.params.getStorage(), this.params.getIndexID()), "rw");
            if (this.first) {
                this.helper.writeHeader(this.params, this.vrand);
            }
            this.vrand.seek(this.vrand.length());
            this.arand.seek(this.arand.length());
        }
        catch (Exception e) {
            logger.error((Object)"Could not open files to populate. Throwing Exception", (Throwable)e);
            throw new Exception("Could not open files to populate");
        }
    }

    public void populate() throws Exception {
        FileBufferReader reader = null;
        try {
            FeatureVectorElement elem;
            reader = new FileBufferReader(FileHelper.getVAFBufferFile(this.params.getStorage(), this.params.getIndexID()), this.params);
            reader.openForReading();
            long count = this.params.getElementCount();
            float[] xsum = this.params.getXSum();
            float[] x2sum = this.params.getX2Sum();
            while ((elem = reader.readElement()) != null) {
                byte[] bitString = ApproximationGenerator.generate(this.params.getPartitionPoints(), elem.getVector(), this.params);
                long apstart = this.arand.getFilePointer();
                this.helper.writeApproximation(new ApproximationFileEntry(bitString, true), this.arand);
                long apstop = this.arand.getFilePointer();
                long vstart = this.vrand.getFilePointer();
                this.helper.writeRecord(new VectorFileEntry(elem.getId(), elem.getVector(), true), this.vrand);
                long vstop = this.vrand.getFilePointer();
                if (this.params.getApproximationEntryLength() == 0L) {
                    this.params.setApproximationEntryLength(apstop - apstart);
                } else if (this.params.getApproximationEntryLength() != apstop - apstart) {
                    throw new Exception("different approximation disk length");
                }
                if (this.params.getVectorEntryLength() == 0L) {
                    this.params.setVectorEntryLength(vstop - vstart);
                } else if (this.params.getVectorEntryLength() != vstop - vstart) {
                    throw new Exception("different vector disk length");
                }
                ++count;
                for (int i = 0; i < elem.getVector().length; ++i) {
                    int n = i;
                    xsum[n] = xsum[n] + elem.getVector()[i];
                    int n2 = i;
                    x2sum[n2] = x2sum[n2] + elem.getVector()[i] * elem.getVector()[i];
                }
            }
            reader.close();
            this.params.setElementCount(count);
            this.params.setXSum(xsum);
            this.params.setX2Sum(x2sum);
            float[] weights = this.params.getWeights();
            for (int i = 0; i < this.params.getVectorLength(); ++i) {
                weights[i] = 1.0f / (float)Math.sqrt(Math.abs(x2sum[i] / (float)count - xsum[i] / (float)count * (xsum[i] / (float)count)));
            }
            this.params.setWeights(weights);
        }
        catch (Exception e) {
            logger.error((Object)"Could not finish population. throwing Exception", (Throwable)e);
            if (reader != null) {
                reader.close();
            }
            throw new Exception("Could not finish population");
        }
    }

    public void close() throws Exception {
        try {
            this.helper.writeHeader(this.params, this.vrand);
            this.vrand.getFD().sync();
            this.arand.getFD().sync();
            this.vrand.close();
            this.arand.close();
        }
        catch (Exception e) {
            logger.error((Object)"Could not close population. throwing Exception", (Throwable)e);
            throw new Exception("Could not close population");
        }
    }
}

