/*
 * QueryTerm.java
 *
 * $Author: tsakas $
 * $Date: 2007/12/20 14:37:39 $
 * $Id: QueryTerm.java,v 1.1 2007/12/20 14:37:39 tsakas Exp $
 *
 * <pre>
 *             Copyright (c) : 2006 Fast Search & Transfer ASA
 *                             ALL RIGHTS RESERVED
 * </pre>
 */
package org.gcube.indexmanagement.lucenewrapper;

/**
 * Holds a query term constructed by the QueryTermFilter.
 */
public final class QueryTerm {

    /** The query term text. */
    private String term;

    /** The query term field. */
    private String field;

    /**
     * Standard constructor.
     * 
     * @param field
     *            The query term field.
     * @param term
     *            The query term text.
     */
    public QueryTerm(String field, String term) {
        this.term = term;
        this.field = field;
    }

    /**
     * Returns the query term text.
     * 
     * @return String The query term text.
     */
    public String getTerm() {
        return term;
    }

    /**
     * Returns the query term field.
     * 
     * @return String The query term field.
     */
    public String getField() {
        return field;
    }
}
