/*
 * ForwardIndex.java
 *
 * $Author: spiros $
 * $Date: 2008/03/13 10:10:59 $
 * $Id: ForwardIndex.java,v 1.2 2008/03/13 10:10:59 spiros Exp $
 *
 * <pre>
 *             Copyright (c) : 2006 Fast Search & Transfer ASA
 *                             ALL RIGHTS RESERVED
 * </pre>
 */

package org.gcube.indexmanagement.common;
   
   
/**   
 * This interface contains the methods that are specified for the  
 * forward index, and that is used and
 * known by the clients of the service. These operations are also
 * specified in the WSDL for the service
 * Since the implementation of the service uses Derby, there is also
 * another interface that is specified in
 * the DerbyInterface. If the service is implemented using the Derby Db,
 * the service also must implement the
 * DerbyInterface.
 * Interface for Index Searching Wrapper Classes.
 */
public interface ForwardIndex {

    /**
     * Gets the key and value pairs where keys are equal the input key.
     * @param keyEQ - contains the ley.
     * @param bKeysOnly return only keys, or full tuples?
     * @return String - the result of the get request.
     * @throws IndexException in case of failure.
     */
    public String getEQ(String keyName, Object keyEQ, ResultType resType)
        throws IndexException;

    /**
     * Gets the key and value pairs where keys are GE the input key.
     * @param key              The key to search for.
     * @param bKeysOnly return only keys, or full tuples?
     * @return String       The result of the get request.
     * @throws IndexException  Exception thrown in case of failure.
     */
    public String getGE(String keyName, Object key, ResultType resType)
        throws IndexException;

    /**
     * Gets the key and value pairs where keys are GT the input key.
     * @param key                The key to search for.
     * @param bKeysOnly return only keys, or full tuples?
     * @return String         The result of the get request.
     * @throws IndexException    Exception thrown in case of failure.
     */
    public String getGT(String keyName, Object key, ResultType resType)
        throws IndexException;

    /**
     * Gets the key and value pairs where keys are LT the input key.
     * @param keyLT -  contains the key.
     * @param bKeysOnly return only keys, or full tuples?
     * @return String - the result of the get request.
     * @throws IndexException    Exception thrown in case of failure.
     */
    public String getLT(String keyName, Object keyLT, ResultType resType)
        throws IndexException;

    /**
     * Gets the key and value pairs where keys are LE the input key.
     * @param keyLE           The key to search for.
     * @param bKeysOnly return only keys, or full tuples?
     * @return String      The result of the get request.
     * @throws IndexException Exception thrown in case of failure.
     */
    public String getLE(String keyName, Object keyLE, ResultType resType)
        throws IndexException;

    /**
     * Gets the key and value pairs where keys are GT the input key1.
     * and LT the input key2.
     * @param keyGT           The key to search for res > key.
     * @param keyLT           The key to search for res < key.
     * @param bKeysOnly return only keys, or full tuples?
     * @return String      The result of the get request.
     * @throws IndexException Thrown in case of failure.
     */
    public String getGTandLT(String keyName, Object keyGT, Object keyLT, ResultType resType)
        throws IndexException;

    /**
     * Gets the key and value pairs where keys are GE the input key1
     * and LT the input key2.
     * @param keyGE            The key to search for res >= key.
     * @param keyLT            The key to search for res < key.
     * @param bKeysOnly return only keys, or full tuples?
     * @return String       The result of the get request.
     * @throws IndexException  Thrown in the case of failure.
     */
    public  String getGEandLT(String keyName, Object keyGE, Object keyLT, ResultType resType)
        throws IndexException;

    /**
     * Gets the key and value pairs where keys are GT the input key1
     * and LE the input key2.
     * @param keyGT            The key to search for res > key.
     * @param keyLE            The key to search for res <= key.
     * @param bKeysOnly return only keys, or full tuples?
     * @return String       The result of the get request.
     * @throws IndexException  Thrown in the case of failure.
     */
    public  String getGTandLE(String keyName, Object keyGT, Object keyLE, ResultType resType)
        throws IndexException;

    /**
     * Gets the key and value pairs where keys are GE the input key1
     * and LE the input key2.
     * @param keyGE            The key to search for res >= key.
     * @param keyLE            The key to search for res <= key.
     * @param bKeysOnly return only keys, or full tuples?
     * @return String       The result of the get request.
     * @throws IndexException  Thrown in the case of failure.
     */
    public  String getGEandLE(String keyName, Object keyGE, Object keyLE, ResultType resType)
        throws IndexException;

}
