package org.gcube.indexmanagement.bdbwrapper;

import com.sleepycat.bind.tuple.StringBinding;
import com.sleepycat.je.DatabaseEntry;

/** 
 * This class compares two Strings.
 * It compares its two arguments for order. Returns a negative integer, 
 * zero, or a positive integer as the first argument is less than, 
 * equal to, or greater than the second.
 */
public final class StringComparator implements java.util.Comparator<byte[]>, java.io.Serializable
{

	public StringComparator(){}
    /**
     * Compares its two arguments for order. Returns a negative integer,
     * zero, or a positive integer as the first argument is less than, equal to, 
     * or greater than the second.
     * @param obj1 - The first String to compare
     * @param obj2 - The second String to compare
     * @return - a negative integer, zero, or a positive integer as the first
     *           argument is less than, equal to, or greater than the second.
     */
    public int compare(byte[] obj1,
                       byte[] obj2) {
    	
    	DatabaseEntry entry1 = new DatabaseEntry();
        DatabaseEntry entry2 = new DatabaseEntry();
        entry1.setData(obj1);
        entry2.setData(obj2);
        String s1 = StringBinding.entryToString(entry1);
        String s2 = StringBinding.entryToString(entry2);
        return s1.compareTo(s2);
    }
}