/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.common;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.gcube.common.core.informationsystem.notifier.ISNotifier;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.indexmanagement.common.IndexNotificationConsumer;
import org.gcube.indexmanagement.common.IndexWSResource;
import org.gcube.indexmanagement.common.notifications.NotifierRequestQueue;
import org.gcube.indexmanagement.common.notifications.SubscribeToNotificationRequest;
import org.gcube.indexmanagement.common.notifications.UnsubscribeFromNotificationRequest;
import org.w3c.dom.Element;

public abstract class IndexUpdaterWSResource
extends IndexWSResource {
    public static final String RP_CONNECTION_ID = "ConnectionID";
    public static final String RP_INDEX_STATUS = "IndexStatus";
    public static final String RP_IS_UPDATED = "IsUpdated";
    public static final String RP_DELTA_FILE_SIZE = "DeltaFileSize";
    public static final String UPDATER_STATUS_EMPTY = "EMPTY";
    public static final String UPDATER_STATUS_UPDATING = "UPDATING";
    public static final String UPDATER_STATUS_FINISHED = "FINISHED";
    private static final String STATE_CHANGE_TOPIC_NAME = "SharedStateChange";
    protected QName sharedStateChangeTopicName;
    private String managementServiceNamespace;

    public void initialize(String namespace, String managementServiceNamespace, String indexID, String indexTypeName, String[] collectionID) throws Exception {
        super.initialise(namespace, indexID, indexTypeName, collectionID);
        this.managementServiceNamespace = managementServiceNamespace;
        this.createProperty(RP_CONNECTION_ID);
        this.createProperty(RP_INDEX_STATUS);
        this.getResourcePropertySet().get(RP_INDEX_STATUS).clear();
        this.getResourcePropertySet().get(RP_INDEX_STATUS).add((Object)UPDATER_STATUS_EMPTY);
        this.createProperty(RP_IS_UPDATED);
        this.getResourcePropertySet().get(RP_IS_UPDATED).clear();
        this.getResourcePropertySet().get(RP_IS_UPDATED).add((Object)new Boolean(false));
        this.createProperty(RP_DELTA_FILE_SIZE);
        this.getResourcePropertySet().get(RP_DELTA_FILE_SIZE).clear();
        this.getResourcePropertySet().get(RP_DELTA_FILE_SIZE).add((Object)new Long(1500000L));
        this.sharedStateChangeTopicName = new QName(managementServiceNamespace + "/" + indexID, STATE_CHANGE_TOPIC_NAME);
        ArrayList<QName> topicSubscriptions = new ArrayList<QName>();
        topicSubscriptions.add(this.sharedStateChangeTopicName);
        GCUBEScope scope = this.getServiceContext().getScope();
        NotifierRequestQueue.getInstance().add(new SubscribeToNotificationRequest(topicSubscriptions, new ConsumerNotification(scope), this.getServiceContext(), scope));
        logger.debug((Object)("Consumer subscribed for notification on topic: " + this.sharedStateChangeTopicName));
    }

    @Override
    protected void onLoad(ObjectInputStream ois, boolean firstLoad) throws Exception {
        super.onLoad(ois, firstLoad);
        this.createProperty(RP_CONNECTION_ID);
        int size = ois.readInt();
        for (int i = 0; i < size; ++i) {
            this.getResourcePropertySet().get(RP_CONNECTION_ID).add((Object)ois.readInt());
        }
        String status = (String)ois.readObject();
        this.createProperty(RP_INDEX_STATUS);
        this.getResourcePropertySet().get(RP_INDEX_STATUS).clear();
        this.getResourcePropertySet().get(RP_INDEX_STATUS).add((Object)status);
        Boolean isUpdated = ois.readBoolean();
        this.createProperty(RP_IS_UPDATED);
        this.getResourcePropertySet().get(RP_IS_UPDATED).clear();
        this.getResourcePropertySet().get(RP_IS_UPDATED).add((Object)isUpdated);
        Long deltaFileSize = ois.readLong();
        this.createProperty(RP_DELTA_FILE_SIZE);
        this.getResourcePropertySet().get(RP_DELTA_FILE_SIZE).clear();
        this.getResourcePropertySet().get(RP_DELTA_FILE_SIZE).add((Object)deltaFileSize);
        this.managementServiceNamespace = (String)ois.readObject();
        if (firstLoad) {
            this.sharedStateChangeTopicName = new QName(this.managementServiceNamespace + "/" + this.getIndexID(), STATE_CHANGE_TOPIC_NAME);
            ArrayList<QName> topicSubscriptions = new ArrayList<QName>();
            topicSubscriptions.add(this.sharedStateChangeTopicName);
            GCUBEScope scope = GCUBEScope.getScope((String)((String)this.getResourcePropertySet().getScope().get(0)));
            NotifierRequestQueue.getInstance().add(new SubscribeToNotificationRequest(topicSubscriptions, new ConsumerNotification(scope), this.getServiceContext(), scope));
            logger.debug((Object)("Consumer subscribed for notification on topic: " + this.sharedStateChangeTopicName));
        }
    }

    @Override
    protected void onStore(ObjectOutputStream oos) throws Exception {
        super.onStore(oos);
        int size = this.getResourcePropertySet().get(RP_CONNECTION_ID).size();
        oos.writeInt(size);
        for (int i = 0; i < size; ++i) {
            oos.writeInt((Integer)this.getResourcePropertySet().get(RP_CONNECTION_ID).get(i));
        }
        oos.writeObject((String)this.getResourcePropertySet().get(RP_INDEX_STATUS).get(0));
        oos.writeBoolean((Boolean)this.getResourcePropertySet().get(RP_IS_UPDATED).get(0));
        oos.writeLong((Long)this.getResourcePropertySet().get(RP_DELTA_FILE_SIZE).get(0));
        oos.writeObject(this.managementServiceNamespace);
    }

    public String getIndexStatus() {
        return (String)this.getResourcePropertySet().get(RP_INDEX_STATUS).get(0);
    }

    public long getDeltaFileSize() {
        return (Long)this.getResourcePropertySet().get(RP_DELTA_FILE_SIZE).get(0);
    }

    public boolean getIsUpdated() {
        return (Boolean)this.getResourcePropertySet().get(RP_IS_UPDATED).get(0);
    }

    public void addConnectionID(int connID) {
        this.getResourcePropertySet().get(RP_CONNECTION_ID).add((Object)new Integer(connID));
    }

    public String getConnectionID() {
        return (String)this.getResourcePropertySet().get(RP_CONNECTION_ID).get(0);
    }

    public synchronized void setConnectionID(String connectionID) throws Exception {
        this.getResourcePropertySet().get(RP_CONNECTION_ID).clear();
        this.getResourcePropertySet().get(RP_CONNECTION_ID).add((Object)connectionID);
    }

    public void setDeltaFileSize(long mergeInterval) {
        this.getResourcePropertySet().get(RP_DELTA_FILE_SIZE).clear();
        this.getResourcePropertySet().get(RP_DELTA_FILE_SIZE).add((Object)new Long(mergeInterval));
    }

    public void setIsUpdated(boolean isUpdated) {
        this.getResourcePropertySet().get(RP_IS_UPDATED).clear();
        this.getResourcePropertySet().get(RP_IS_UPDATED).add((Object)new Boolean(isUpdated));
    }

    public void setIndexStatus(String indexStatus) {
        this.getResourcePropertySet().get(RP_INDEX_STATUS).clear();
        this.getResourcePropertySet().get(RP_INDEX_STATUS).add((Object)indexStatus);
    }

    public String getManagementResourceNamespace() {
        return this.managementServiceNamespace;
    }

    @Override
    public void onResourceRemoval() {
        super.onResourceRemoval();
        try {
            ArrayList<QName> topicSubscriptions = new ArrayList<QName>();
            topicSubscriptions.add(this.sharedStateChangeTopicName);
            NotifierRequestQueue.getInstance().add(new UnsubscribeFromNotificationRequest(topicSubscriptions, this.getServiceContext(), this.getServiceContext().getScope()));
            logger.debug((Object)("Consumer unsubscribed from notification on topic: " + this.sharedStateChangeTopicName + " for index: " + this.getIndexID()));
        }
        catch (Exception e) {
            logger.debug((Object)"Failed to unregister notification topics from the IS.", (Throwable)e);
        }
    }

    public abstract void onUpdaterNotificationReceived(Element var1);

    public class ConsumerNotification
    extends IndexNotificationConsumer {
        public ConsumerNotification(GCUBEScope scope) {
            super(IndexUpdaterWSResource.this, scope);
        }

        @Override
        protected void onNewNotification(ISNotifier.NotificationEvent event) {
            logger.debug((Object)"Index notification consumer received notification message.");
            Element message = null;
            try {
                message = (Element)((ISNotifier.NotificationMessage)event.getPayload()).getMessageObject();
                IndexUpdaterWSResource.this.onUpdaterNotificationReceived(message);
            }
            catch (Exception e) {
                logger.debug((Object)"Error in onNotificationReceived.", (Throwable)e);
            }
        }
    }
}

