/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.featureindexlibrary.vafile.io;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import org.apache.log4j.Logger;
import org.gcube.indexmanagement.featureindexlibrary.commons.FeatureVectorElement;
import org.gcube.indexmanagement.featureindexlibrary.vafile.VAFileParams;

public class FileBufferReader {
    private static Logger log = Logger.getLogger(FileBufferReader.class);
    private String file = null;
    private FileInputStream fis = null;
    private BufferedInputStream bis = null;
    private DataInputStream dis = null;
    private int idlength = 0;
    private int vectorlength = 0;

    public FileBufferReader(String file, VAFileParams params) {
        this.file = file;
        this.idlength = params.getIDLength();
        this.vectorlength = params.getVectorLength();
    }

    private String readString() {
        try {
            char[] idA = new char[this.idlength];
            for (int i = 0; i < idA.length; ++i) {
                idA[i] = this.dis.readChar();
            }
            return new String(idA);
        }
        catch (EOFException e) {
            return null;
        }
        catch (Exception e) {
            log.debug((Object)"Could not read apprixmiation. assuming EOF", (Throwable)e);
            return null;
        }
    }

    private float[] readVector() {
        try {
            float[] vector = new float[this.vectorlength];
            for (int i = 0; i < vector.length; ++i) {
                vector[i] = this.dis.readFloat();
            }
            return vector;
        }
        catch (EOFException e) {
            return null;
        }
        catch (Exception e) {
            log.debug((Object)"Could not read apprixmiation. assuming EOF", (Throwable)e);
            return null;
        }
    }

    public void openForReading() throws Exception {
        try {
            this.fis = new FileInputStream(this.file);
            this.bis = new BufferedInputStream(this.fis);
            this.dis = new DataInputStream(this.bis);
        }
        catch (Exception e) {
            log.error((Object)"Could not open for reading. Throwing Exception", (Throwable)e);
            throw new Exception("Could not open for reading");
        }
    }

    public FeatureVectorElement readElement() {
        String id = this.readString();
        float[] vector = this.readVector();
        if (id == null || vector == null) {
            return null;
        }
        return new FeatureVectorElement(id, vector);
    }

    public void close() throws Exception {
        try {
            if (this.fis != null) {
                this.fis.close();
            }
            if (this.dis != null) {
                this.dis.close();
            }
            if (this.bis != null) {
                this.bis.close();
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not close reader. Throwing Exception", (Throwable)e);
            throw new Exception("Could not close reader");
        }
    }
}

