package org.gcube.indexmanagement.featureindexlibrary.commons;

import org.apache.log4j.Logger;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.indexmanagement.common.ServiceContextContainer;

/**
 * Statistics container
 * 
 * @author UoA
 */
public class FeatureIndexStatsContainer extends Thread {
	/**
	 * Logger used by the class
	 */
	private static Logger log = Logger.getLogger(FeatureIndexStatsContainer.class);
	/**
	 * Used for synchronization
	 */
	private Object lockMe=new Object();
	/**
	 * The service class
	 */
	private String ServiceClass=null;
	/**
	 * The service name
	 */
	private String ServiceName=null;
	/**
	 * Number of invocations
	 */
	private long NumberOfInvocations=0;
	/**
	 * Number of add operations
	 */
	private long NumberOfAdditions=0;
	/**
	 * Number of additions
	 */
	private long MeanRecordsInAdditions=0;
	/**
	 * mean addition time
	 */
	private long MeanAdditionTime=0;
	/**
	 * max addition time
	 */
	private long MaxAdditionTime=0;
	/**
	 * min addition time
	 */
	private long MinAdditionTime=Long.MAX_VALUE;
	/**
	 * Number of removals
	 */
	private long NumberOfRemovals=0;
	/**
	 * removal Time
	 */
	private long RemovalTime =0;
	/**
	 * Number of lookups
	 */
	private long NumberOfLookups=0;
	/**
	 * mean index lookup time
	 */
	private long MeanIndexLookupTime=0;
	/**
	 * max index lookup time
	 */
	private long MaxIndexLookupTime=0;
	/**
	 * min index lookup time
	 */
	private long MinIndexLookupTime=Long.MAX_VALUE;
	/**
	 * mean number of lookup results
	 */
	private long MeanLookupResults=0; 
	/**
	 * max number of lookup results
	 */
	private long MaxLookupResults=0;
	/**
	 * min number of lookup results
	 */
	private long MinLookupResults=Long.MAX_VALUE;
	
	private ServiceContextContainer ServiceContextCont = null;
	
	/**
	 * Constructor
	 * 
	 * @param ServiceClass the Service class
	 * @param ServiceName the service name
	 */
	public FeatureIndexStatsContainer(String ServiceClass, String ServiceName, ServiceContextContainer ServiceContextCont){
		this.ServiceClass=ServiceClass;
		this.ServiceName=ServiceName;
		this.ServiceContextCont = ServiceContextCont;
	}
	
	/**
	 * new invocation
	 */
	public void newInvocation(){
		synchronized(lockMe){
			this.NumberOfInvocations+=1;
		}
	}
	
	/**
	 * add operations
	 * 
	 * @param number the number of records added
	 */
	public void addRecords(long number){
		synchronized(lockMe){
			this.NumberOfAdditions+=1;
			this.MeanRecordsInAdditions=((this.MeanRecordsInAdditions*(this.NumberOfAdditions-1))+number)/this.NumberOfAdditions;
		}
	}
	
	/**
	 * add records time
	 * 
	 * @param time the time of addition
	 */
	public void addRecordsTime(long time){
		synchronized(lockMe){
			if(this.MinAdditionTime>time) this.MinAdditionTime=time;
			if(this.MaxAdditionTime<time) this.MaxAdditionTime=time;
			if(this.NumberOfAdditions!=0) this.MeanAdditionTime=((this.MeanAdditionTime*(this.NumberOfAdditions-1))+time)/this.NumberOfAdditions;
		}
	}
	
	/**
	 * new removal
	 */
	public void newRemoval(){
		synchronized(lockMe){
			this.NumberOfRemovals+=1;
		}
	}
	
	/**
	 * removal time
	 * 
	 * @param time the time
	 */
	public void removalTime(long time){
		synchronized(lockMe){
			this.RemovalTime+=time;
		}
	}
	
	/**
	 * Index lookups
	 */
	public void newIndexLookup(){
		synchronized(lockMe){
			this.NumberOfLookups+=1;
		}
	}
		
	/**
	 * lookup Index
	 * 
	 * @param time the time
	 */
	public void lookupIndex(long time){
		synchronized(lockMe){
			if(this.MinIndexLookupTime>time) this.MinIndexLookupTime=time;
			if(this.MaxIndexLookupTime<time) this.MaxIndexLookupTime=time;
			if(this.NumberOfLookups!=0) this.MeanIndexLookupTime=((this.MeanIndexLookupTime*(this.NumberOfLookups-1)+time)/this.NumberOfLookups);
		}
	}
	
	/**
	 * number of results
	 * 
	 * @param results lookup results
	 */
	public void lookupResults(long results){
		synchronized(lockMe){
			if(this.MinLookupResults>results) this.MinLookupResults=results;
			if(this.MaxLookupResults<results) this.MaxLookupResults=results;
			if(this.NumberOfLookups!=0) this.MeanLookupResults=((this.MeanLookupResults*(this.NumberOfLookups-1)+results)/this.NumberOfLookups);
		}
	}
	
	/**
	 * Writes the statistics to the RI profile
	 * @throws Exception the ri could not be updated
	 */
	public void writeToRI() throws Exception{
		
		ServiceContextCont.getContext().getInstance().setSpecificData(this.toXML());
		
	}
	
	/**
	 * @see java.lang.Runnable#run()
	 */
	public void run(){
		while(true){
			try{
				Thread.sleep(1200000); //20 minutes
			}catch(Exception e){}
			try{
				this.writeToRI();
			}catch(Exception e){
				log.error("could not update RI profile.continuing",e);
			}
		}
	}
	/**
	 * generates an xml serialization of the statistics
	 * 
	 * @return the xml serialization
	 */
	public String toXML(){
		StringBuilder buf=new StringBuilder();
		buf.append("<Statistics>");
		buf.append("<text>");
		buf.append("this section summarizes some statisitc information for the service since the last restart");
		buf.append("</text>");
		buf.append("<NumberOfInvocations>");
		buf.append("<value>");
		buf.append(NumberOfInvocations);
		buf.append("</value>");
		buf.append("<description>");
		buf.append("the total number of calls made to the service");
		buf.append("</description>");
		buf.append("</NumberOfInvocations>");
		buf.append("<NumberOfAdditions>");
		buf.append("<value>");
		buf.append(NumberOfAdditions);
		buf.append("</value>");
		buf.append("<description>");
		buf.append("the total number of calls made for adding records to an index");
		buf.append("</description>");
		buf.append("</NumberOfAdditions>");
		buf.append("<MeanRecordsInAdditions>");
		buf.append("<value>");
		buf.append(MeanRecordsInAdditions);
		buf.append("</value>");
		buf.append("<description>");
		buf.append("the mean number of records in addition requests");
		buf.append("</description>");
		buf.append("</MeanRecordsInAdditions>");
		buf.append("<MeanAdditionTime>");
		buf.append("<value>");
		buf.append(MeanAdditionTime);
		buf.append("</value>");
		buf.append("<description>");
		buf.append("the mean time in addition requests");
		buf.append("</description>");
		buf.append("</MeanAdditionTime>");
		buf.append("<MaxAdditionTime>");
		buf.append("<value>");
		buf.append(MaxAdditionTime);
		buf.append("</value>");
		buf.append("<description>");
		buf.append("the max time in addition requests");
		buf.append("</description>");
		buf.append("</MaxAdditionTime>");
		buf.append("<MinAdditionTime>");
		buf.append("<value>");
		buf.append(MinAdditionTime);
		buf.append("</value>");
		buf.append("<description>");
		buf.append("the min time in addition requests");
		buf.append("</description>");
		buf.append("</MinAdditionTime>");
		buf.append("<NumberOfRemovals>");
		buf.append("<value>");
		buf.append(NumberOfRemovals);
		buf.append("</value>");
		buf.append("<description>");
		buf.append("the number of removal requests");
		buf.append("</description>");
		buf.append("</NumberOfRemovals>");
		buf.append("<RemovalTime>");
		buf.append("<value>");
		buf.append(RemovalTime);
		buf.append("</value>");
		buf.append("<description>");
		buf.append("the time for removal requests");
		buf.append("</description>");
		buf.append("</RemovalTime>");
		buf.append("<NumberOfLookups>");
		buf.append("<value>");
		buf.append(NumberOfLookups);
		buf.append("</value>");
		buf.append("<description>");
		buf.append("the total lookup requests");
		buf.append("</description>");
		buf.append("</NumberOfLookups>");
		buf.append("<MeanIndexLookupTime>");
		buf.append("<value>");
		buf.append(MeanIndexLookupTime);
		buf.append("</value>");
		buf.append("<description>");
		buf.append("the mean time for a lookup");
		buf.append("</description>");
		buf.append("</MeanIndexLookupTime>");
		buf.append("<MeanLookupResults>");
		buf.append("<value>");
		buf.append(MeanLookupResults);
		buf.append("</value>");
		buf.append("<description>");
		buf.append("the mean results for a lookup");
		buf.append("</description>");
		buf.append("</MeanLookupResults>");
		buf.append("<MaxLookupResults>");
		buf.append("<value>");
		buf.append(MaxLookupResults);
		buf.append("</value>");
		buf.append("<description>");
		buf.append("the max results for a lookup");
		buf.append("</description>");
		buf.append("</MaxLookupResults>");
		buf.append("<MinLookupResults>");
		buf.append("<value>");
		buf.append(MinLookupResults);
		buf.append("</value>");
		buf.append("<description>");
		buf.append("the min results for a lookup");
		buf.append("</description>");
		buf.append("</MinLookupResults>");
		buf.append("</Statistics>");
		return buf.toString();
	}
}
