/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.lucenewrapper;

import org.apache.lucene.search.DefaultSimilarity;

class GlobalSimilarity
extends DefaultSimilarity {
    private static double mmf1 = 4.0;
    private static double mmf2 = 2.0;

    GlobalSimilarity() {
    }

    public float lengthNorm(String fieldName, int numTerms) {
        return (float)Math.sqrt(GlobalSimilarity.factor(numTerms) / (double)numTerms);
    }

    public float tf(float freq) {
        return (float)Math.sqrt(freq);
    }

    private static double f(double mag) {
        if (mag < 0.0) {
            return 0.0;
        }
        double result = 0.0;
        double magf = Math.floor(mag);
        long i = 0L;
        while ((double)i < magf) {
            result += (double)i / ((double)i + 1.0);
            ++i;
        }
        return result += (mag - magf) * (magf / (magf + 1.0));
    }

    private static double factor(long size) {
        double mag = size < 10L ? 0.0 : Math.log10((double)size / 10.0);
        return Math.pow(10.0, mag) / (Math.pow(mmf1, mag) / Math.pow(mmf2, GlobalSimilarity.f(mag)));
    }
}

