package org.gcube.indexmanagement.featureindexlibrary.vafile.io;

import java.io.*;

import org.apache.log4j.Logger;
import org.gcube.indexmanagement.featureindexlibrary.commons.*;
import org.gcube.indexmanagement.featureindexlibrary.vafile.VAFileParams;

/**
 * B uffer reader class
 * 
 * @author UoA
 */
public class FileBufferReader {
	/**
	 * Logger used by the class
	 */
	private static Logger log = Logger.getLogger(FileBufferReader.class);
	/**
	 * The file
	 */
	private String file=null;
	/**
	 * The input stream
	 */
	private FileInputStream fis=null;
	/**
	 * The input stream
	 */
	private BufferedInputStream bis=null;
	/**
	 * The input stream
	 */
	private DataInputStream dis=null;
	/**
	 * The length of the id
	 */
	private int idlength=0;
	/**
	 * The length of the vector
	 */
	private int vectorlength=0;
	
	/**
	 * Creates a new instance
	 * 
	 * @param file The file
	 * @param params The VAFile header params
	 */
	public FileBufferReader(String file,VAFileParams params){
		this.file=file;
		this.idlength=params.getIDLength();
		this.vectorlength=params.getVectorLength();
	}
	
	/**
	 * Reads a string
	 * 
	 * @return Th estring
	 */
	private String readString(){
		try{
			char []idA=new char[this.idlength];
			for(int i=0;i<idA.length;i+=1){
				idA[i]=dis.readChar();
			}
			return new String(idA);
		}catch(EOFException e){
			return null;
		}catch(Exception e){
			log.debug("Could not read apprixmiation. assuming EOF",e);
			return null;
		}
	}
	
	/**
	 * Reads a vector
	 * 
	 * @return The vector
	 */
	private float []readVector(){
		try{
			float []vector=new float[this.vectorlength];
			for(int i=0;i<vector.length;i+=1){
				vector[i]=dis.readFloat();
			}
			return vector;
		}catch(EOFException e){
			return null;
		}catch(Exception e){
			log.debug("Could not read apprixmiation. assuming EOF",e);
			return null;
		}
	}
	
	/**
	 * Opens for reading
	 * 
	 * @throws Exception An error
	 */
	public void openForReading() throws Exception{
		try{
			fis=new FileInputStream(this.file);
			bis=new BufferedInputStream(fis);
			dis=new DataInputStream(bis);
		}catch(Exception e){
			log.error("Could not open for reading. Throwing Exception",e);
			throw new Exception("Could not open for reading");
		}
	}
	
	/**
	 * Reads element
	 * 
	 * @return The element
	 */
	public FeatureVectorElement readElement(){
		String id=this.readString();
		float []vector=this.readVector();
		if(id==null || vector==null) return null;
		return new FeatureVectorElement(id,vector);
	}
	
	/**
	 * Closes
	 * 
	 * @throws Exception An error
	 */
	public void close() throws Exception{
		try{
			if(fis!=null) fis.close();
			if(dis!=null) dis.close();
			if(bis!=null) bis.close();
		}catch(Exception e){
			log.error("Could not close reader. Throwing Exception",e);
			throw new Exception("Could not close reader");
		}
	}
}
