package org.gcube.indexmanagement.featureindexlibrary.vafile.elements;

/**
 * Entry stored in approximation file
 * 
 * @author UoA
 */
public class ApproximationFileEntry {
	/**
	 * The bit string
	 */
	private byte []bitString=null;
	/**
	 * Record is actoive
	 */
	private boolean active=true;
	
	/**
	 * Creates new instance
	 * 
	 * @param bitString The bit string
	 * @param active entry active
	 */
	public ApproximationFileEntry(byte []bitString,boolean active){
		this.bitString=bitString;
		this.active=active;
	}

	/**
	 * Creates a new instance
	 * 
	 * @param bitString The bit string
	 */
	public ApproximationFileEntry(byte []bitString){
		this.bitString=bitString;
		this.active=true;
	}

	/**
	 * Getter of property
	 * 
	 * @return The property
	 */
	public boolean isActive() {
		return active;
	}

	/**
	 * Setter of property
	 * 
	 * @param active The property value
	 */
	public void setActive(boolean active) {
		this.active = active;
	}

	/**
	 * Getter of property
	 * 
	 * @return The property
	 */
	public byte[] getBitString() {
		return bitString;
	}

	/**
	 * Setter of property
	 * 
	 * @param bitString The property value
	 */
	public void setBitString(byte[] bitString) {
		this.bitString = bitString;
	}
}
