/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.geo;

import com.vividsolutions.jts.geom.Envelope;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.indexmanagement.common.IndexException;
import org.gcube.indexmanagement.geo.DataWrapper;
import org.gcube.indexmanagement.geo.GeoIndexType;
import org.gcube.indexmanagement.geo.InclusionType;
import org.gcube.indexmanagement.geo.QueryResults;
import org.gcube.indexmanagement.geo.ranking.RankEvaluator;
import org.gcube.indexmanagement.geo.refinement.Refiner;
import org.geotools.index.Data;
import org.geotools.index.LockTimeoutException;
import org.geotools.index.TreeException;
import org.geotools.index.rtree.PageStore;
import org.geotools.index.rtree.RTree;
import org.geotools.index.rtree.fs.FileSystemPageStore;

public class RTreeWrapper
extends RTree
implements Comparable<RTreeWrapper> {
    static GCUBELog logger = new GCUBELog(RTreeWrapper.class);
    private long maxArea;
    private GeoIndexType indexTypeObject;
    private String indexFile;
    private RandomAccessFile rawData;

    public RTreeWrapper(File indexFile, GeoIndexType indexTypeObject, RandomAccessFile rawData) throws TreeException {
        super((PageStore)(indexFile.exists() ? new FileSystemPageStore(indexFile) : new FileSystemPageStore(indexFile, DataWrapper.createDefinition())));
        this.indexTypeObject = indexTypeObject;
        this.indexFile = indexFile.getAbsolutePath();
        this.rawData = rawData;
    }

    public RTreeWrapper(File indexFile, GeoIndexType indexTypeObject, long maxArea, RandomAccessFile rawData) throws TreeException {
        this(indexFile, indexTypeObject, rawData);
        this.maxArea = maxArea;
    }

    public void insert(DataWrapper geoData) throws IndexException {
        try {
            this.insert(geoData.getMbr(), geoData.getData());
        }
        catch (Exception e) {
            throw new IndexException(e);
        }
    }

    public void setMaxArea(long area) {
        this.maxArea = area;
    }

    public long getMaxArea() {
        return this.maxArea;
    }

    @Override
    public int compareTo(RTreeWrapper object) {
        return new Long(this.maxArea).compareTo(new Long(object.getMaxArea()));
    }

    public String getIndexFile() {
        return this.indexFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryResults performQuery(Envelope query, InclusionType method, Refiner[] refiners, RankEvaluator ranker) throws TreeException, LockTimeoutException, Exception {
        List includesMatches;
        ArrayList<Data> matches = new ArrayList<Data>();
        RTreeWrapper rTreeWrapper = this;
        synchronized (rTreeWrapper) {
            includesMatches = super.search(query);
        }
        logger.info((Object)("The underlying rtree query: " + query + " returned " + includesMatches.size() + " results."));
        if (method == InclusionType.intersect) {
            logger.info((Object)"Intersect chosen: complete rtree results returned.");
            return new QueryResults(this.indexTypeObject, includesMatches, refiners, ranker, this.rawData);
        }
        for (Data data : includesMatches) {
            boolean hit;
            Envelope entry = new Envelope((double)((Long)data.getValue(0)).longValue(), (double)((Long)data.getValue(1)).longValue(), (double)((Long)data.getValue(2)).longValue(), (double)((Long)data.getValue(3)).longValue());
            switch (method) {
                case contains: {
                    hit = query.contains(entry);
                    break;
                }
                case inside: {
                    hit = entry.contains(query);
                    break;
                }
                default: {
                    hit = false;
                }
            }
            if (!hit) continue;
            matches.add(data);
        }
        logger.info((Object)("Refined rtree results using \"" + (Object)((Object)method) + "\" to " + matches.size() + " results."));
        return new QueryResults(this.indexTypeObject, matches, refiners, ranker, this.rawData);
    }

    public static enum GeoSearchModifiers {
        colID,
        lang,
        inclusion,
        refiner,
        ranker,
        not;

    }

    public static enum SupportedRelations {
        geosearch;

    }
}

