/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.featureindexlibrary.vafile.io;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import org.apache.log4j.Logger;
import org.gcube.indexmanagement.featureindexlibrary.commons.FileHelper;
import org.gcube.indexmanagement.featureindexlibrary.vafile.VAFileParams;
import org.gcube.indexmanagement.featureindexlibrary.vafile.elements.VectorFileEntry;
import org.gcube.indexmanagement.featureindexlibrary.vafile.elements.VectorFileEntryInfo;
import org.gcube.indexmanagement.featureindexlibrary.vafile.io.IOHelper;

public class VectorFileReader {
    private static Logger log = Logger.getLogger(VectorFileReader.class);
    private VAFileParams params = null;
    private FileInputStream fis = null;
    private BufferedInputStream bis = null;
    private DataInputStream dis = null;
    private IOHelper helper = null;
    private int count = 0;

    public VectorFileReader(VAFileParams params) throws Exception {
        this.params = params;
        this.helper = new IOHelper();
        this.helper.setIDLength(params.getIDLength());
        this.helper.setVectorLength(params.getVectorLength());
        this.count = 0;
    }

    public void open() throws Exception {
        try {
            this.fis = new FileInputStream(FileHelper.getVAFVectorFile(this.params.getStorage(), this.params.getIndexID()));
            this.bis = new BufferedInputStream(this.fis);
            this.dis = new DataInputStream(this.bis);
        }
        catch (Exception e) {
            log.error((Object)"Could not create reader. Throwing Exception", (Throwable)e);
            throw new Exception("Could not create reader");
        }
    }

    public VectorFileEntryInfo getNext() {
        try {
            VectorFileEntry entry = this.helper.readRecord(this.dis);
            ++this.count;
            if (entry.isActive()) {
                return new VectorFileEntryInfo(entry, this.count - 1);
            }
            return this.getNext();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void close() throws Exception {
        try {
            this.dis.close();
            this.bis.close();
            this.fis.close();
        }
        catch (Exception e) {
            log.error((Object)"Could not close reader. Throwing Exception", (Throwable)e);
            throw new Exception("Could not close reader");
        }
    }
}

