/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.bdbwrapper;

import com.sleepycat.bind.tuple.FloatBinding;
import com.sleepycat.bind.tuple.IntegerBinding;
import com.sleepycat.bind.tuple.StringBinding;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.OperationStatus;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPWriterProxy;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.StringFieldDefinition;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.StringReader;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import jdbm.helper.Tuple;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.PropertyElementBase;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementBase;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementGeneric;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSLocator;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceWSRFType;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSXMLWriter;
import org.gcube.indexmanagement.bdbwrapper.BDBGcqlProcessor;
import org.gcube.indexmanagement.bdbwrapper.BDBGcqlQueryContainer;
import org.gcube.indexmanagement.bdbwrapper.BDBQueryExecutor;
import org.gcube.indexmanagement.bdbwrapper.CustomDate;
import org.gcube.indexmanagement.bdbwrapper.DateComparator;
import org.gcube.indexmanagement.bdbwrapper.FloatComparator;
import org.gcube.indexmanagement.bdbwrapper.IntegerComparator;
import org.gcube.indexmanagement.bdbwrapper.StringComparator;
import org.gcube.indexmanagement.common.ForwardIndex;
import org.gcube.indexmanagement.common.ForwardIndexField;
import org.gcube.indexmanagement.common.ForwardIndexType;
import org.gcube.indexmanagement.common.IndexException;
import org.gcube.indexmanagement.common.PropertyElementForwardIndex;
import org.gcube.indexmanagement.common.ResultType;
import org.gcube.indexmanagement.common.XMLTokenReplacer;
import org.gcube.indexmanagement.resourceregistry.RRadaptor;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class BDBWrapper
implements ForwardIndex {
    public static final String EXACT = "==";
    public static final String WITHIN = "within";
    public static String[] SupportedRelations = new String[]{"==", "within"};
    private String dbName;
    private String resourceId;
    private String treeName;
    private Environment env;
    private Database[] db;
    private Database dbMain;
    static GCUBELog logger = new GCUBELog(BDBWrapper.class);
    private Comparator[] comparator;
    private HashMap<String, Integer> keyTypes = new HashMap();
    private ForwardIndexType[] dbT;
    private int[] numKeys;
    private int numDocs;
    private static final String contentName = "Objects";
    static final String NODOCID = "NoDocID";
    private long packageSize = 10L;
    private File envDir;
    private EnvironmentConfig envConfig;
    private DatabaseConfig[] dbConfig;
    private DatabaseConfig dbConfigMain;
    private String[] keyNames;
    private RRadaptor adaptor = null;

    public BDBWrapper(String baseDir, String dbName, String resourceId, String[] keyNames, ForwardIndexType[] dbT) throws IndexException {
        logger.debug((Object)(" >>> BDBWrapper \nbaseDir: " + baseDir + "dbName: " + dbName + "treeName: " + this.treeName + "dbT " + dbT));
        this.envDir = new File(baseDir);
        this.envConfig = new EnvironmentConfig();
        this.envConfig.setAllowCreate(true);
        try {
            this.env = new Environment(this.envDir, this.envConfig);
        }
        catch (Exception e) {
            logger.error((Object)("Corrupted Environment in the directory: " + baseDir));
            throw new IndexException("Corrupted Environment in the directory: " + baseDir);
        }
        this.dbName = dbName;
        this.resourceId = resourceId;
        this.dbT = dbT;
        if (keyNames.length != dbT.length) {
            throw new IndexException("keyNames length isn't equal to dbT length");
        }
        this.keyNames = keyNames;
        try {
            this.db = new Database[keyNames.length];
            this.comparator = new Comparator[keyNames.length];
            this.numKeys = new int[keyNames.length];
            this.dbConfig = new DatabaseConfig[keyNames.length];
            for (int i = 0; i < keyNames.length; ++i) {
                this.keyTypes.put(keyNames[i], i);
                this.dbConfig[i] = new DatabaseConfig();
                this.dbConfig[i].setAllowCreate(true);
                this.dbConfig[i].setDeferredWrite(true);
                this.dbConfig[i].setSortedDuplicates(true);
                if (dbT[i].getKeyField().getDataType() == ForwardIndexField.DataType.DATE) {
                    this.dbConfig[i].setBtreeComparator(DateComparator.class);
                    this.comparator[i] = new DateComparator();
                } else if (dbT[i].getKeyField().getDataType() == ForwardIndexField.DataType.STRING) {
                    this.dbConfig[i].setBtreeComparator(StringComparator.class);
                    this.comparator[i] = new StringComparator();
                } else if (dbT[i].getKeyField().getDataType() == ForwardIndexField.DataType.INT) {
                    this.comparator[i] = new IntegerComparator();
                } else if (dbT[i].getKeyField().getDataType() == ForwardIndexField.DataType.FLOAT) {
                    this.comparator[i] = new FloatComparator();
                }
                this.db[i] = this.env.openDatabase(null, this.convertToIndexName(keyNames[i]), this.dbConfig[i]);
                this.numKeys[i] = (int)this.db[i].count();
            }
            this.dbConfigMain = new DatabaseConfig();
            this.dbConfigMain.setAllowCreate(true);
            this.dbConfigMain.setDeferredWrite(true);
            this.dbMain = this.env.openDatabase(null, this.convertToIndexNameMain(contentName), this.dbConfigMain);
            this.numDocs = (int)this.dbMain.count();
            logger.debug((Object)" <<< BDBWrapper");
        }
        catch (Exception e) {
            logger.error((Object)"db create failed ", (Throwable)e);
        }
    }

    public int getNumDocs() {
        return this.numDocs;
    }

    public int[] getNumKeys() {
        return this.numKeys;
    }

    public long getPackageSize() {
        return this.packageSize;
    }

    public void setPackageSize(long packageSize) {
        this.packageSize = packageSize;
    }

    private String convertToIndexName(String keyName) {
        return this.dbName + "_" + this.resourceId + "_" + keyName;
    }

    private String convertToIndexNameMain(String name) {
        return this.dbName + "_" + name + "_" + this.resourceId;
    }

    public void close() throws Exception {
        for (int i = 0; i < this.db.length; ++i) {
            this.db[i].close();
        }
        this.dbMain.close();
        Set<String> c = this.keyTypes.keySet();
        Iterator<String> iter = c.iterator();
        while (iter.hasNext()) {
            this.env.removeDatabase(null, this.convertToIndexName(iter.next()));
        }
        this.env.removeDatabase(null, this.convertToIndexNameMain(contentName));
        this.env.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            for (int i = 0; i < this.db.length; ++i) {
                this.db[i].close();
            }
            this.dbMain.close();
            this.env.close();
        }
        finally {
            super.finalize();
        }
    }

    private boolean insertPairInDb(String keyName, String key, DatabaseEntry value) throws IndexException {
        logger.debug((Object)(" >>> insertPairInDb key/valueid:  " + key + " / " + StringBinding.entryToString((DatabaseEntry)value)));
        DatabaseEntry keyValue = new DatabaseEntry();
        boolean added = false;
        if (!this.keyTypes.containsKey(keyName)) {
            logger.error((Object)("keyName: " + keyName + " was not declared when the constructor was called. " + "There is no index for this keyName"));
            throw new IndexException("keyName: " + keyName + " was not declared when the constructor was called. " + "There is no index for this keyName");
        }
        int pos = this.keyTypes.get(keyName);
        if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.DATE) {
            keyValue.setData(BDBWrapper.convertToDate(key, this.dbT[pos].getKeyField().getDataTypeFormat()).getBytes());
        } else if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.FLOAT) {
            FloatBinding.floatToEntry((float)BDBWrapper.convertToFloat(key), (DatabaseEntry)keyValue);
        } else if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.INT) {
            IntegerBinding.intToEntry((int)BDBWrapper.convertToInt(key), (DatabaseEntry)keyValue);
        } else if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.STRING) {
            StringBinding.stringToEntry((String)key, (DatabaseEntry)keyValue);
        }
        try {
            if (this.db[pos].getSearchBoth(null, keyValue, value, null) == OperationStatus.NOTFOUND && this.db[pos].put(null, keyValue, value) == OperationStatus.SUCCESS) {
                int n = pos;
                this.numKeys[n] = this.numKeys[n] + 1;
                added = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)(" *** insertPairInDb error message: " + e.getMessage()));
            throw new IndexException("Could not insert key/valueid:  " + key + " / " + StringBinding.entryToString((DatabaseEntry)value) + " for keyName: " + keyName + " error: " + e.getMessage());
        }
        logger.debug((Object)" <<< insertPairInDb");
        return added;
    }

    private int deleteValueFromDb(String keyName, String id) throws Exception {
        logger.debug((Object)(" >>> deleteValueFromDb: " + id));
        DatabaseEntry keyValue = new DatabaseEntry();
        DatabaseEntry bindKey = new DatabaseEntry();
        DatabaseEntry bindKey2 = new DatabaseEntry();
        StringBinding.stringToEntry((String)id, (DatabaseEntry)bindKey2);
        if (!this.keyTypes.containsKey(keyName)) {
            throw new IndexException("keyName: " + keyName + " was not declared when the constructor was called. " + "There is no index for this keyName");
        }
        int pos = this.keyTypes.get(keyName);
        int refs = 0;
        Cursor cursor = this.db[pos].openCursor(null, null);
        try {
            OperationStatus opSt = OperationStatus.SUCCESS;
            while (opSt == OperationStatus.SUCCESS) {
                opSt = cursor.getNext(keyValue, bindKey, null);
                if (!bindKey.equals((Object)bindKey2)) continue;
                if (cursor.delete() == OperationStatus.SUCCESS) {
                    logger.debug((Object)("deleted key from Index: " + keyName));
                    int n = pos;
                    this.numKeys[n] = this.numKeys[n] - 1;
                    ++refs;
                    continue;
                }
                throw new Exception("cursor.delete() was not successful");
            }
            cursor.close();
        }
        catch (Exception e) {
            cursor.close();
            logger.error((Object)("Could not delete entry from index with keyName: " + keyName + " that refers to id: " + id));
            throw new Exception("Could not delete entry from index with keyName: " + keyName + " that refers to id: " + id + " error: " + e.getMessage());
        }
        return refs;
    }

    private int deletePairInDb(String keyName, String key, String id) throws Exception {
        logger.debug((Object)(" >>> deletePairInDb: " + key));
        DatabaseEntry keyValue = new DatabaseEntry();
        DatabaseEntry bindKey = new DatabaseEntry();
        StringBinding.stringToEntry((String)id, (DatabaseEntry)bindKey);
        if (!this.keyTypes.containsKey(keyName)) {
            throw new IndexException("keyName: " + keyName + " was not declared when the constructor was called. " + "There is no index for this keyName");
        }
        int pos = this.keyTypes.get(keyName);
        if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.DATE) {
            keyValue.setData(BDBWrapper.convertToDate(key, this.dbT[pos].getKeyField().getDataTypeFormat()).getBytes());
        } else if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.FLOAT) {
            FloatBinding.floatToEntry((float)BDBWrapper.convertToFloat(key), (DatabaseEntry)keyValue);
        } else if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.INT) {
            IntegerBinding.intToEntry((int)BDBWrapper.convertToInt(key), (DatabaseEntry)keyValue);
        } else if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.STRING) {
            StringBinding.stringToEntry((String)key, (DatabaseEntry)keyValue);
        }
        Cursor cursor = this.db[pos].openCursor(null, null);
        try {
            if (cursor.getSearchBoth(keyValue, bindKey, null) == OperationStatus.NOTFOUND) {
                logger.error((Object)("Could not find key: " + key + " for keyName: " + keyName + "and for id: " + id));
                return 0;
            }
            if (cursor.delete() != OperationStatus.SUCCESS) {
                throw new IndexException("Could not delete key:  " + key + " for keyName: " + keyName + " and for id: " + id);
            }
            int n = pos;
            this.numKeys[n] = this.numKeys[n] - 1;
            cursor.close();
        }
        catch (Exception e) {
            cursor.close();
            logger.error((Object)(" *** deletePairInDb error message: " + e.getMessage()));
            throw new IndexException("Could not delete key/id: " + key + "/" + id + " for keyName: " + keyName + " error: " + e.getMessage());
        }
        return 1;
    }

    private void addToResults(RSXMLWriter writer, Object key, long id) throws Exception {
        String xmlResult = null;
        String resolvedKey = XMLTokenReplacer.XMLResolve(key.toString());
        xmlResult = "<tuple>";
        xmlResult = xmlResult + "<key>";
        xmlResult = xmlResult + resolvedKey;
        xmlResult = xmlResult + "</key>";
        xmlResult = xmlResult + "<valueid>";
        xmlResult = xmlResult + id;
        xmlResult = xmlResult + "</valueid>";
        xmlResult = xmlResult + "</tuple>";
        writer.addResults((ResultElementBase)new ResultElementGeneric("1", "1", xmlResult));
        logger.debug((Object)"=================================");
        logger.debug((Object)("BDBWrapper added key/dataID: " + xmlResult));
        logger.debug((Object)"=================================");
    }

    private void addToResults(RSXMLWriter writer, Object key) throws Exception {
        String resolvedKey = XMLTokenReplacer.XMLResolve(key.toString());
        String xmlResult = "<key>" + resolvedKey + "</key>";
        writer.addResults((ResultElementBase)new ResultElementGeneric("1", "1", xmlResult));
        logger.debug((Object)"=================================");
        logger.debug((Object)("BDBWrapper added key: " + xmlResult));
        logger.debug((Object)"=================================");
    }

    private void addData(RSXMLWriter writer, Vector<String> data, boolean bDataOnly) throws Exception {
        for (int i = 0; i < data.size(); ++i) {
            logger.debug((Object)("adding " + i + " data element to RS"));
            long time1 = Calendar.getInstance().getTimeInMillis();
            long time2 = Calendar.getInstance().getTimeInMillis();
            String stringXML = XMLTokenReplacer.XMLResolve(data.get(i));
            time1 = time2;
            time2 = Calendar.getInstance().getTimeInMillis();
            logger.debug((Object)("XMLResolve after " + (time2 - time1)));
            time1 = time2;
            time2 = Calendar.getInstance().getTimeInMillis();
            logger.debug((Object)("RS_fromXML after " + (time2 - time1)));
            String xmlResult = null;
            if (!bDataOnly) {
                xmlResult = "<value>" + stringXML + "</value>";
                time1 = time2;
                time2 = Calendar.getInstance().getTimeInMillis();
                logger.debug((Object)("String concat after " + (time2 - time1)));
            } else {
                xmlResult = stringXML;
            }
            ResultElementGeneric tmp = new ResultElementGeneric("1", "1", xmlResult);
            time1 = time2;
            time2 = Calendar.getInstance().getTimeInMillis();
            logger.debug((Object)("new ResultElementGeneric after" + (time2 - time1)));
            time1 = time2;
            time2 = Calendar.getInstance().getTimeInMillis();
            logger.debug((Object)("set atributes after " + (time2 - time1)));
            writer.addResults((ResultElementBase)tmp);
            time1 = time2;
            time2 = Calendar.getInstance().getTimeInMillis();
            logger.debug((Object)("added to RS writer after " + (time2 - time1)));
            logger.debug((Object)"=================================");
            logger.debug((Object)("BDBWrapper added data. Local iteration: " + i));
            logger.debug((Object)"=================================");
        }
    }

    @Override
    public String getEQ(final String keyName, final Object key, final ResultType resType) throws IndexException {
        RSLocator locator = null;
        try {
            int maxHits = 1000;
            PropertyElementBase[] properties = new PropertyElementBase[]{new PropertyElementForwardIndex(maxHits)};
            final RSXMLWriter rsWriter = RSXMLWriter.getRSXMLWriter((PropertyElementBase[])properties);
            locator = rsWriter.getRSLocator((RSResourceType)new RSResourceWSRFType());
            new Thread(){

                @Override
                public void run() {
                    logger.debug((Object)(" >>> getEQ for key: " + key));
                    try {
                        BDBWrapper.this.scanIndex(rsWriter, keyName, resType, key, true, key, true, false);
                        rsWriter.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)(" *** getEQ error key: " + key + " message: " + e.getMessage()));
                        try {
                            rsWriter.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    logger.debug((Object)" <<< getEQ");
                }
            }.start();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return locator.getLocator();
    }

    @Override
    public String getGE(final String keyName, final Object keyGE, final ResultType resType) throws IndexException {
        RSLocator locator = null;
        try {
            int maxHits = 1000;
            PropertyElementBase[] properties = new PropertyElementBase[]{new PropertyElementForwardIndex(maxHits)};
            final RSXMLWriter rsWriter = RSXMLWriter.getRSXMLWriter((PropertyElementBase[])properties);
            locator = rsWriter.getRSLocator((RSResourceType)new RSResourceWSRFType());
            new Thread(){

                @Override
                public void run() {
                    logger.debug((Object)(" >>> getGE for key: " + keyGE));
                    try {
                        BDBWrapper.this.scanIndex(rsWriter, keyName, resType, keyGE, true, null, false, false);
                        rsWriter.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)(" *** getGE error for key: " + keyGE + " message: " + e.getMessage()));
                        try {
                            rsWriter.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    logger.debug((Object)" <<< getGE");
                }
            }.start();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return locator.getLocator();
    }

    @Override
    public String getGT(final String keyName, final Object keyGT, final ResultType resType) throws IndexException {
        RSLocator locator = null;
        try {
            int maxHits = 1000;
            PropertyElementBase[] properties = new PropertyElementBase[]{new PropertyElementForwardIndex(maxHits)};
            final RSXMLWriter rsWriter = RSXMLWriter.getRSXMLWriter((PropertyElementBase[])properties);
            locator = rsWriter.getRSLocator((RSResourceType)new RSResourceWSRFType());
            new Thread(){

                @Override
                public void run() {
                    logger.debug((Object)(" >>> getGT for key: " + keyGT));
                    try {
                        BDBWrapper.this.scanIndex(rsWriter, keyName, resType, keyGT, false, null, false, false);
                        rsWriter.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)(" *** getGT error for key: " + keyGT + " message: " + e.getMessage()));
                        try {
                            rsWriter.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    logger.debug((Object)" <<< getGT");
                }
            }.start();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return locator.getLocator();
    }

    @Override
    public String getLE(final String keyName, final Object keyLE, final ResultType resType) throws IndexException {
        RSLocator locator = null;
        try {
            int maxHits = 1000;
            PropertyElementBase[] properties = new PropertyElementBase[]{new PropertyElementForwardIndex(maxHits)};
            final RSXMLWriter rsWriter = RSXMLWriter.getRSXMLWriter((PropertyElementBase[])properties);
            locator = rsWriter.getRSLocator((RSResourceType)new RSResourceWSRFType());
            new Thread(){

                @Override
                public void run() {
                    logger.debug((Object)(" >>> getLE for key: " + keyLE));
                    try {
                        BDBWrapper.this.scanIndex(rsWriter, keyName, resType, null, false, keyLE, true, false);
                        rsWriter.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)(" *** getLE error for key: " + keyLE + " message: " + e.getMessage()));
                        try {
                            rsWriter.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    logger.debug((Object)" <<< getLE");
                }
            }.start();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return locator.getLocator();
    }

    @Override
    public String getLT(final String keyName, final Object keyLT, final ResultType resType) throws IndexException {
        RSLocator locator = null;
        try {
            int maxHits = 1000;
            PropertyElementBase[] properties = new PropertyElementBase[]{new PropertyElementForwardIndex(maxHits)};
            final RSXMLWriter rsWriter = RSXMLWriter.getRSXMLWriter((PropertyElementBase[])properties);
            locator = rsWriter.getRSLocator((RSResourceType)new RSResourceWSRFType());
            new Thread(){

                @Override
                public void run() {
                    logger.debug((Object)(" >>> getLT for key: " + keyLT));
                    try {
                        BDBWrapper.this.scanIndex(rsWriter, keyName, resType, null, false, keyLT, false, false);
                        rsWriter.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)(" *** getLT error for key: " + keyLT + " message: " + e.getMessage()));
                        try {
                            rsWriter.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    logger.debug((Object)" <<< getLT");
                }
            }.start();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return locator.getLocator();
    }

    @Override
    public String getGEandLE(final String keyName, final Object keyGE, final Object keyLE, final ResultType resType) throws IndexException {
        RSLocator locator = null;
        try {
            int maxHits = 1000;
            PropertyElementBase[] properties = new PropertyElementBase[]{new PropertyElementForwardIndex(maxHits)};
            final RSXMLWriter rsWriter = RSXMLWriter.getRSXMLWriter((PropertyElementBase[])properties);
            locator = rsWriter.getRSLocator((RSResourceType)new RSResourceWSRFType());
            new Thread(){

                @Override
                public void run() {
                    logger.debug((Object)(" >>> getGEandLE for keyGE " + keyGE + " keyLE " + keyLE));
                    try {
                        BDBWrapper.this.scanIndex(rsWriter, keyName, resType, keyGE, true, keyLE, true, false);
                        rsWriter.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)(" *** getGEandLE for keyGE and keyLE: " + keyGE + " / " + keyLE + " message: " + e.getMessage()));
                        try {
                            rsWriter.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    logger.debug((Object)" <<< getGEandLE");
                }
            }.start();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return locator.getLocator();
    }

    @Override
    public String getGEandLT(final String keyName, final Object keyGE, final Object keyLT, final ResultType resType) throws IndexException {
        RSLocator locator = null;
        try {
            int maxHits = 1000;
            PropertyElementBase[] properties = new PropertyElementBase[]{new PropertyElementForwardIndex(maxHits)};
            final RSXMLWriter rsWriter = RSXMLWriter.getRSXMLWriter((PropertyElementBase[])properties);
            locator = rsWriter.getRSLocator((RSResourceType)new RSResourceWSRFType());
            new Thread(){

                @Override
                public void run() {
                    logger.debug((Object)(" >>> getGEandLT for keyGE " + keyGE + " keyLT " + keyLT));
                    try {
                        BDBWrapper.this.scanIndex(rsWriter, keyName, resType, keyGE, true, keyLT, false, false);
                        rsWriter.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)(" *** getGEandLT for keyGE and keyLT: " + keyGE + " / " + keyLT + " message: " + e.getMessage()));
                        try {
                            rsWriter.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    logger.debug((Object)" <<< getGEandLT");
                }
            }.start();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return locator.getLocator();
    }

    @Override
    public String getGTandLE(final String keyName, final Object keyGT, final Object keyLE, final ResultType resType) throws IndexException {
        RSLocator locator = null;
        try {
            int maxHits = 1000;
            PropertyElementBase[] properties = new PropertyElementBase[]{new PropertyElementForwardIndex(maxHits)};
            final RSXMLWriter rsWriter = RSXMLWriter.getRSXMLWriter((PropertyElementBase[])properties);
            locator = rsWriter.getRSLocator((RSResourceType)new RSResourceWSRFType());
            new Thread(){

                @Override
                public void run() {
                    logger.debug((Object)(" >>> getGTandLE for keyGT " + keyGT + " keyLE " + keyLE));
                    try {
                        BDBWrapper.this.scanIndex(rsWriter, keyName, resType, keyGT, false, keyLE, true, false);
                        rsWriter.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)(" *** getGTandLE for keyGT and keyLE: " + keyGT + " / " + keyLE + " message: " + e.getMessage()));
                        try {
                            rsWriter.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    logger.debug((Object)" <<< getGTandLE");
                }
            }.start();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return locator.getLocator();
    }

    @Override
    public String getGTandLT(final String keyName, final Object keyGT, final Object keyLT, final ResultType resType) throws IndexException {
        RSLocator locator = null;
        try {
            int maxHits = 1000;
            PropertyElementBase[] properties = new PropertyElementBase[]{new PropertyElementForwardIndex(maxHits)};
            final RSXMLWriter rsWriter = RSXMLWriter.getRSXMLWriter((PropertyElementBase[])properties);
            locator = rsWriter.getRSLocator((RSResourceType)new RSResourceWSRFType());
            new Thread(){

                @Override
                public void run() {
                    logger.debug((Object)(" >>> getGTandLT for keyGT " + keyGT + " keyLT " + keyLT));
                    try {
                        BDBWrapper.this.scanIndex(rsWriter, keyName, resType, keyGT, false, keyLT, false, false);
                        rsWriter.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)(" *** getGTandLT for keyGT and keyLT: " + keyGT + " / " + keyLT + " message: " + e.getMessage()));
                        try {
                            rsWriter.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    logger.debug((Object)" >>> getGTandLT");
                }
            }.start();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return locator.getLocator();
    }

    public String getAllDec(final String keyName, final ResultType resType) throws IndexException {
        RSLocator locator = null;
        try {
            int maxHits = 1000;
            PropertyElementBase[] properties = new PropertyElementBase[]{new PropertyElementForwardIndex(maxHits)};
            final RSXMLWriter rsWriter = RSXMLWriter.getRSXMLWriter((PropertyElementBase[])properties);
            locator = rsWriter.getRSLocator((RSResourceType)new RSResourceWSRFType());
            new Thread(){

                @Override
                public void run() {
                    logger.debug((Object)" >>> getAllDec");
                    try {
                        BDBWrapper.this.scanIndex(rsWriter, keyName, resType, null, false, null, false, true);
                        rsWriter.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)(" *** getAllDec  message: " + e.getMessage()));
                        try {
                            rsWriter.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    logger.debug((Object)" >>> getAllDec");
                }
            }.start();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return locator.getLocator();
    }

    public String getAllInc(final String keyName, final ResultType resType) throws IndexException {
        RSLocator locator = null;
        try {
            int maxHits = 1000;
            PropertyElementBase[] properties = new PropertyElementBase[]{new PropertyElementForwardIndex(maxHits)};
            final RSXMLWriter rsWriter = RSXMLWriter.getRSXMLWriter((PropertyElementBase[])properties);
            locator = rsWriter.getRSLocator((RSResourceType)new RSResourceWSRFType());
            new Thread(){

                @Override
                public void run() {
                    logger.debug((Object)" >>> getAllInc");
                    try {
                        BDBWrapper.this.scanIndex(rsWriter, keyName, resType, null, false, null, false, false);
                        rsWriter.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)(" *** getAllInc  message: " + e.getMessage()));
                        try {
                            rsWriter.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    logger.debug((Object)" >>> getAllInc");
                }
            }.start();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return locator.getLocator();
    }

    private void scanIndex(RSXMLWriter rsWriter, String keyName, ResultType resType, Object left, boolean gequal, Object right, boolean lequal, boolean dec) throws Exception {
        boolean bDataOnly = false;
        boolean bKeysOnly = false;
        if (resType == ResultType.KEYS) {
            bKeysOnly = true;
        } else if (resType == ResultType.DATA) {
            bDataOnly = true;
        }
        Integer pos = this.keyTypes.get(keyName);
        if (pos == null) {
            throw new IndexException("keyName: " + keyName + " was not declared when the constructor was called. " + "There is no index for this keyName");
        }
        DatabaseEntry greater = null;
        DatabaseEntry lower = null;
        if (left != null) {
            greater = new DatabaseEntry();
            if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.DATE) {
                greater.setData(BDBWrapper.convertToDate(left, this.dbT[pos].getKeyField().getDataTypeFormat()).getBytes());
            } else if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.FLOAT) {
                FloatBinding.floatToEntry((float)BDBWrapper.convertToFloat(left), (DatabaseEntry)greater);
            } else if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.INT) {
                IntegerBinding.intToEntry((int)BDBWrapper.convertToInt(left), (DatabaseEntry)greater);
            } else if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.STRING) {
                StringBinding.stringToEntry((String)((String)left), (DatabaseEntry)greater);
            }
        }
        if (right != null) {
            lower = new DatabaseEntry();
            if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.DATE) {
                lower.setData(BDBWrapper.convertToDate(right, this.dbT[pos].getKeyField().getDataTypeFormat()).getBytes());
            } else if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.FLOAT) {
                FloatBinding.floatToEntry((float)BDBWrapper.convertToFloat(right), (DatabaseEntry)lower);
            } else if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.INT) {
                IntegerBinding.intToEntry((int)BDBWrapper.convertToInt(right), (DatabaseEntry)lower);
            } else if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.STRING) {
                StringBinding.stringToEntry((String)((String)right), (DatabaseEntry)lower);
            }
        }
        HashMap<String, Long> sentData = new HashMap<String, Long>();
        Vector<String> current = new Vector<String>();
        long currentLength = 0L;
        long id = 1L;
        DatabaseEntry keyValue = new DatabaseEntry();
        DatabaseEntry bindKey = new DatabaseEntry();
        DatabaseEntry value = new DatabaseEntry();
        Object key = null;
        OperationStatus opSt = OperationStatus.SUCCESS;
        Cursor cursor = this.db[pos].openCursor(null, null);
        try {
            if (greater != null) {
                keyValue.setData(greater.getData());
                opSt = cursor.getSearchKeyRange(keyValue, bindKey, null);
                if (!gequal && this.comparator[pos].compare(keyValue.getData(), greater.getData()) == 0) {
                    opSt = cursor.getNextNoDup(keyValue, bindKey, null);
                }
            } else {
                opSt = dec ? cursor.getPrev(keyValue, bindKey, null) : cursor.getNext(keyValue, bindKey, null);
            }
            while (opSt == OperationStatus.SUCCESS && (lower == null || this.comparator[pos].compare(keyValue.getData(), lower.getData()) <= 0 && (this.comparator[pos].compare(keyValue.getData(), lower.getData()) != 0 || lequal))) {
                Long dataId = (Long)sentData.get(StringBinding.entryToString((DatabaseEntry)bindKey));
                if (dataId == null) {
                    logger.debug((Object)("sentData.get() returned null for valueid(bindKey)" + StringBinding.entryToString((DatabaseEntry)bindKey) + "(" + bindKey + ")"));
                } else {
                    logger.debug((Object)("sentData.get() returned: " + dataId + " for valueid(bindKey)" + StringBinding.entryToString((DatabaseEntry)bindKey) + "(" + bindKey + ")"));
                }
                if (dataId == null && !bKeysOnly) {
                    logger.debug((Object)("valueID(bindkey):" + StringBinding.entryToString((DatabaseEntry)bindKey) + "(" + bindKey + ") is added to sentData"));
                    if (this.dbMain.get(null, bindKey, value, null) == OperationStatus.NOTFOUND) {
                        logger.error((Object)"Reference to actual data not found. Index is corrupted!");
                        throw new Exception("Reference to actual data not found. Index is corrupted!");
                    }
                    String s = StringBinding.entryToString((DatabaseEntry)value);
                    s = BDBWrapper.extractValueFromEntry(s);
                    current.add(s);
                    sentData.put(StringBinding.entryToString((DatabaseEntry)bindKey), id);
                    if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.DATE) {
                        key = CustomDate.toCustomDate(keyValue.getData());
                    } else if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.FLOAT) {
                        key = Float.valueOf(FloatBinding.entryToFloat((DatabaseEntry)keyValue));
                    } else if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.INT) {
                        key = IntegerBinding.entryToInt((DatabaseEntry)keyValue);
                    } else if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.STRING) {
                        key = StringBinding.entryToString((DatabaseEntry)keyValue);
                    }
                    if (!bDataOnly) {
                        this.addToResults(rsWriter, key, id);
                    }
                    logger.debug((Object)("Found key/id: " + key + "/" + StringBinding.entryToString((DatabaseEntry)bindKey)));
                    ++id;
                } else {
                    logger.debug((Object)("valueID(bindkey):" + StringBinding.entryToString((DatabaseEntry)bindKey) + "(" + bindKey + ") is already added to sentData"));
                    if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.DATE) {
                        key = CustomDate.toCustomDate(keyValue.getData());
                    } else if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.FLOAT) {
                        key = Float.valueOf(FloatBinding.entryToFloat((DatabaseEntry)keyValue));
                    } else if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.INT) {
                        key = IntegerBinding.entryToInt((DatabaseEntry)keyValue);
                    } else if (this.dbT[pos].getKeyField().getDataType() == ForwardIndexField.DataType.STRING) {
                        key = StringBinding.entryToString((DatabaseEntry)keyValue);
                    }
                    if (bKeysOnly) {
                        this.addToResults(rsWriter, key);
                    } else if (!bDataOnly) {
                        this.addToResults(rsWriter, key, dataId);
                    }
                    logger.debug((Object)("Found key/id: " + key + "/" + StringBinding.entryToString((DatabaseEntry)bindKey)));
                }
                if (++currentLength == this.packageSize && !bKeysOnly) {
                    this.addData(rsWriter, current, bDataOnly);
                    currentLength = 0L;
                    current.clear();
                }
                if (dec) {
                    if (bKeysOnly) {
                        opSt = cursor.getPrevNoDup(keyValue, bindKey, null);
                        continue;
                    }
                    opSt = cursor.getPrev(keyValue, bindKey, null);
                    continue;
                }
                if (bKeysOnly) {
                    opSt = cursor.getNextNoDup(keyValue, bindKey, null);
                    continue;
                }
                opSt = cursor.getNext(keyValue, bindKey, null);
            }
            if (current.size() > 0 && !bKeysOnly) {
                this.addData(rsWriter, current, bDataOnly);
            }
            cursor.close();
        }
        catch (Exception e) {
            cursor.close();
            throw e;
        }
    }

    public URI processQuery(String cqlQuery, ArrayList<String> presentable, ArrayList<String> searchable, RRadaptor adaptor) throws GRS2WriterException {
        RecordWriter rsWriter = null;
        this.adaptor = adaptor;
        try {
            BDBGcqlProcessor processor = new BDBGcqlProcessor();
            BDBGcqlQueryContainer queryCont = (BDBGcqlQueryContainer)processor.processQuery(presentable, searchable, cqlQuery, adaptor);
            ArrayList<ArrayList<BDBGcqlQueryContainer.SingleTerm>> queries = queryCont.getBdbQueries();
            LinkedHashMap<String, String> projections = queryCont.getProjectedFields();
            boolean distinct = queryCont.getDistinct();
            FieldDefinition[] fieldDef = this.createFieldDefinition(projections, distinct);
            RecordDefinition[] definition = new RecordDefinition[]{new GenericRecordDefinition(fieldDef)};
            rsWriter = new RecordWriter((IWriterProxy)new TCPWriterProxy(), definition);
            new BDBQueryExecutor(this.keyTypes, this.dbT, this.db, this.dbMain, this.comparator, queries, (RecordWriter<GenericRecord>)rsWriter, projections, distinct).start();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return rsWriter.getLocator();
    }

    private FieldDefinition[] createFieldDefinition(LinkedHashMap<String, String> projections, boolean distinct) throws Exception {
        ArrayList<StringFieldDefinition> fieldDef = new ArrayList<StringFieldDefinition>();
        if (!distinct) {
            fieldDef.add(new StringFieldDefinition("ObjectID"));
        }
        for (Map.Entry<String, String> current : projections.entrySet()) {
            fieldDef.add(new StringFieldDefinition(current.getKey()));
        }
        return fieldDef.toArray(new FieldDefinition[fieldDef.size()]);
    }

    public synchronized int mergeDeletion(File deletionFile) throws IndexException {
        try {
            logger.debug((Object)" >>> mergeDeletion");
            logger.debug((Object)" <<< mergeDeletion");
            return 0;
        }
        catch (Exception ex) {
            logger.error((Object)(" *** mergeDeletion error  message: " + ex.getMessage()));
            return 1;
        }
    }

    static int numberOfChars(String input, String countString) {
        return input.split("\\Q" + countString + "\\E", -1).length - 1;
    }

    public synchronized void mergeAddition(File inputIndex) throws IndexException {
        logger.debug((Object)(" >>> mergeAddition file:" + inputIndex));
        boolean index = false;
        try {
            FileInputStream inputStream = new FileInputStream(inputIndex);
            int available = inputStream.available();
            FileChannel deltaChannel = inputStream.getChannel();
            if (available > 0) {
                int i;
                ByteBuffer buffer = ByteBuffer.allocate(available);
                int bytesRead = deltaChannel.read(buffer);
                buffer.flip();
                byte[] c = new byte[buffer.capacity()];
                buffer.get(c);
                String rowSet = "<ROWSET>" + new String(c, "UTF-8") + "</ROWSET>";
                logger.debug((Object)("    rowset\n" + rowSet));
                UpdateXMLParser parser = new UpdateXMLParser();
                parser.parse(rowSet);
                for (i = 0; i < this.db.length; ++i) {
                    this.db[i].close();
                }
                this.dbMain.close();
                this.env.close();
                this.env = new Environment(this.envDir, this.envConfig);
                this.dbMain = this.env.openDatabase(null, this.convertToIndexNameMain(contentName), this.dbConfigMain);
                for (i = 0; i < this.db.length; ++i) {
                    this.db[i] = this.env.openDatabase(null, this.convertToIndexName(this.keyNames[i]), this.dbConfig[i]);
                }
            } else {
                logger.error((Object)(" *** mergeAddition empty file, available bytes: " + available));
                throw new IndexException(" Empty insert file received");
            }
            logger.debug((Object)" <<< mergeAddition");
        }
        catch (Exception ex) {
            logger.error((Object)(" *** mergeAddition error  message: " + ex.getMessage()));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addTuple(Vector<String> keyNames, Vector<String> keyValues, String value) throws Exception {
        DatabaseEntry bindKey = new DatabaseEntry();
        DatabaseEntry valueEntry = new DatabaseEntry();
        logger.debug((Object)"=================================");
        logger.debug((Object)"BDBWrapper.addTuple merging current index with a new tuple");
        logger.debug((Object)"=================================");
        if (keyNames.size() != keyValues.size()) {
            logger.error((Object)"keyNames don't have the same size with keyValues");
            return;
        }
        String lang = "unknown";
        for (int i = 0; i < keyNames.size(); ++i) {
            if (!keyNames.get(i).equals("gDocCollectionLang")) continue;
            lang = keyValues.get(i);
        }
        String stringXML = XMLTokenReplacer.XMLResolve(value);
        String docID = BDBWrapper.getDocIDFromXML(stringXML);
        docID = this.enhanceDocID(docID, lang);
        StringBinding.stringToEntry((String)docID, (DatabaseEntry)bindKey);
        logger.debug((Object)("adding value with id: " + docID));
        int additions = 0;
        for (int i = 0; i < keyNames.size(); ++i) {
            if (!this.insertPairInDb(keyNames.get(i), keyValues.get(i), bindKey)) continue;
            ++additions;
        }
        logger.debug((Object)"addition of keys completed");
        if (this.dbMain.get(null, bindKey, valueEntry, null) == OperationStatus.NOTFOUND) {
            logger.debug((Object)"this DocID is inserted for the first time");
            value = this.convertValueToEntry(additions, value);
            StringBinding.stringToEntry((String)value, (DatabaseEntry)valueEntry);
            logger.debug((Object)("inserting DocID: " + docID + ", to the value index"));
            if (this.dbMain.put(null, bindKey, valueEntry) == OperationStatus.SUCCESS) {
                ++this.numDocs;
                logger.debug((Object)("DocID: " + docID + ", inserted successfully"));
                return;
            }
            logger.error((Object)("could not put actual data to value store: " + value));
            throw new Exception("could not put actual data to value store: " + value);
        }
        logger.debug((Object)"this DocID is already inserted");
        String s = StringBinding.entryToString((DatabaseEntry)valueEntry);
        int refs = BDBWrapper.extractRefsFromEntry(s) + additions;
        value = this.convertValueToEntry(refs, value);
        StringBinding.stringToEntry((String)value, (DatabaseEntry)valueEntry);
        logger.debug((Object)("inserting the updated entry for DocID: " + docID + ", to the value index"));
        if (this.dbMain.put(null, bindKey, valueEntry) != OperationStatus.SUCCESS) {
            logger.error((Object)("could not put actual data to value store: " + value));
            throw new Exception("could not put actual data to value store: " + value);
        }
        logger.debug((Object)("updated entry for DocID: " + docID + ", inserted successfully"));
    }

    public static HashMap<String, String> getPresentationFieldsFromXML(String fieldsString) {
        int from;
        HashMap<String, String> fields = new HashMap<String, String>();
        StringBuilder tmpBuilder = new StringBuilder(fieldsString);
        while (tmpBuilder.indexOf(">") > -1 && (from = tmpBuilder.indexOf("name=\"")) != -1) {
            tmpBuilder.replace(0, from += "name=\"".length(), "");
            int to = tmpBuilder.indexOf("\"");
            String name = tmpBuilder.substring(0, to).trim();
            tmpBuilder.replace(0, to, "");
            from = tmpBuilder.indexOf(">") + ">".length();
            tmpBuilder.replace(0, from, "");
            to = tmpBuilder.indexOf("<");
            if (to == -1) break;
            String value = tmpBuilder.substring(0, to).trim();
            tmpBuilder.replace(0, to, "");
            if (name == null || name.equals("") || value == null || value.equals("")) continue;
            String sumValue = fields.get(name);
            sumValue = sumValue == null ? value : sumValue + " " + value;
            fields.put(name, sumValue);
        }
        return fields;
    }

    public static ArrayList<String> getPresentableFromXML(String fieldsString, String colID, String colLang) {
        HashSet<String> presentable = new HashSet<String>();
        StringBuilder tmpBuilder = new StringBuilder(fieldsString);
        while (tmpBuilder.indexOf(">") > -1) {
            int from = tmpBuilder.indexOf("name=\"") + "name=\"".length();
            tmpBuilder.replace(0, from, "");
            int to = tmpBuilder.indexOf("\"");
            String name = tmpBuilder.substring(0, to).trim();
            tmpBuilder.replace(0, to, "");
            if (name == null || name.equalsIgnoreCase("ObjectID")) continue;
            presentable.add(colID + ":" + colLang + ":" + "p" + ":" + name);
        }
        return new ArrayList<String>(presentable);
    }

    static String getDocIDFromXML(String fieldsString) {
        HashMap fields = new HashMap();
        StringBuilder tmpBuilder = new StringBuilder(fieldsString);
        while (tmpBuilder.indexOf(">") > -1) {
            int from = tmpBuilder.indexOf("name=\"") + "name=\"".length();
            tmpBuilder.replace(0, from, "");
            int to = tmpBuilder.indexOf("\"");
            String name = tmpBuilder.substring(0, to).trim();
            tmpBuilder.replace(0, to, "");
            from = tmpBuilder.indexOf(">") + ">".length();
            tmpBuilder.replace(0, from, "");
            to = tmpBuilder.indexOf("<");
            String value = tmpBuilder.substring(0, to).trim();
            tmpBuilder.replace(0, to, "");
            if (!name.equalsIgnoreCase("ObjectID")) continue;
            if (value == null) {
                logger.error((Object)"No docID value inside presentation field for docID");
                return NODOCID;
            }
            return value;
        }
        logger.error((Object)"No docID value found");
        return NODOCID;
    }

    private String enhanceDocID(String docID, String lang) {
        return lang + ":" + docID;
    }

    private String filterDocID(String docID) {
        return docID.substring(docID.indexOf(":") + ":".length());
    }

    private String convertValueToEntry(int refs, String value) {
        return refs + ":" + value;
    }

    static int extractRefsFromEntry(String value) {
        return Integer.parseInt(value.substring(0, value.indexOf(":")));
    }

    static String extractValueFromEntry(String value) {
        return value.substring(value.indexOf(":") + 1);
    }

    private void deleteAllRefs(String id) throws Exception {
        int refs = 0;
        Iterator<String> iter = this.keyTypes.keySet().iterator();
        while (iter.hasNext()) {
            refs += this.deleteValueFromDb(iter.next(), id);
        }
        if (refs > 0) {
            DatabaseEntry value = new DatabaseEntry();
            DatabaseEntry bindKey = new DatabaseEntry();
            StringBinding.stringToEntry((String)id, (DatabaseEntry)bindKey);
            if (this.dbMain.get(null, bindKey, value, null) == OperationStatus.NOTFOUND) {
                logger.error((Object)"Reference to actual data not found. Index is corrupted!");
                throw new Exception("Reference to actual data not found. Index is corrupted!");
            }
            String s = StringBinding.entryToString((DatabaseEntry)value);
            int newRefs = BDBWrapper.extractRefsFromEntry(s) - refs;
            if (newRefs == 0) {
                if (this.dbMain.delete(null, bindKey) == OperationStatus.SUCCESS) {
                    --this.numDocs;
                }
            } else {
                logger.error((Object)("Data for id: " + id + " are not in valid form. Index is corrupted!"));
                throw new Exception("Data for id: " + id + " are not in valid form. Index is corrupted!");
            }
        }
    }

    private void deleteTuple(Vector<String> keyNames, Vector<String> keyValues, String id) throws Exception {
        if (keyNames.size() != keyValues.size()) {
            logger.error((Object)"keyNames don't have the same size with keyValues");
            return;
        }
        DatabaseEntry bindKey = new DatabaseEntry();
        StringBinding.stringToEntry((String)id, (DatabaseEntry)bindKey);
        for (int i = 0; i < keyNames.size(); ++i) {
            int refs = 0;
            refs = keyValues.get(i).compareTo("*") == 0 ? this.deleteValueFromDb(keyNames.get(i), id) : this.deletePairInDb(keyNames.get(i), keyValues.get(i), id);
            if (refs == 0) continue;
            DatabaseEntry value = new DatabaseEntry();
            if (this.dbMain.get(null, bindKey, value, null) == OperationStatus.NOTFOUND) {
                logger.error((Object)"Reference to actual data not found. Index is corrupted!");
                throw new Exception("Reference to actual data not found. Index is corrupted!");
            }
            String s = StringBinding.entryToString((DatabaseEntry)value);
            int newRefs = BDBWrapper.extractRefsFromEntry(s) - refs;
            if (newRefs == 0) {
                if (this.dbMain.delete(null, bindKey) != OperationStatus.SUCCESS) continue;
                --this.numDocs;
                continue;
            }
            if (newRefs < 0) {
                logger.error((Object)("Data for id: " + id + " are not in valid form. Index is corrupted!"));
                throw new Exception("Data for id: " + id + " are not in valid form. Index is corrupted!");
            }
            s = this.convertValueToEntry(newRefs, BDBWrapper.extractValueFromEntry(s));
            StringBinding.stringToEntry((String)s, (DatabaseEntry)value);
            this.dbMain.put(null, bindKey, value);
        }
    }

    static final int convertToInt(Object in) throws IndexException {
        logger.debug((Object)(" >>> convertToInt input value: " + in));
        try {
            int res = new Integer((String)in);
            logger.debug((Object)(" <<< convertToInt value: " + res));
            return res;
        }
        catch (Exception ex) {
            logger.error((Object)(" *** convertToInt error  message: " + ex.getMessage()));
            throw new IndexException(" *** convertToInt error", ex);
        }
    }

    static final float convertToFloat(Object in) throws IndexException {
        logger.debug((Object)(" >>> convertToFloat input value: " + in));
        try {
            float res = new Float((String)in).floatValue();
            logger.debug((Object)(" <<< convertToFloat float: " + res));
            return res;
        }
        catch (Exception ex) {
            logger.error((Object)(" *** convertToFloat error  message: " + ex.getMessage()));
            throw new IndexException(" *** convertToFloat error", ex);
        }
    }

    static final CustomDate convertToDate(Object in, String format) throws IndexException {
        logger.debug((Object)(" >>> convertToDate input value: " + in));
        try {
            SimpleDateFormat df = new SimpleDateFormat(format);
            CustomDate res = new CustomDate((String)in, df);
            logger.debug((Object)(" <<< convertToDate date: " + res));
            return res;
        }
        catch (Exception ex) {
            logger.error((Object)(" *** convertToDate error  message: " + ex.getMessage()));
            throw new IndexException(" *** convertToDate error", ex);
        }
    }

    static final String convertToString(Object in) throws IndexException {
        logger.debug((Object)(" >>> convertToString input value: " + in));
        try {
            String res = new String((String)in);
            logger.debug((Object)(" <<< convertToString string: " + res));
            return res;
        }
        catch (Exception ex) {
            logger.error((Object)(" *** convertToString error  message: " + ex.getMessage()));
            throw new IndexException(" *** convertToString error", ex);
        }
    }

    public synchronized void updateIndex() throws IndexException {
        logger.debug((Object)" >>> updateIndex");
        logger.debug((Object)" <<< updateIndex");
    }

    private void printRs(String result) {
        logger.info((Object)("Result set: " + result));
    }

    private void printList(LinkedList result) {
        int hits = 0;
        String xmlResult = "<forwardIndexResult>";
        ListIterator it = result.listIterator();
        while (it.hasNext()) {
            Tuple tuple = (Tuple)it.next();
            ++hits;
            xmlResult = xmlResult + "<tuple>";
            xmlResult = xmlResult + "<key>";
            xmlResult = xmlResult + tuple.getKey();
            xmlResult = xmlResult + "</key>";
            xmlResult = xmlResult + "<value>";
            xmlResult = xmlResult + tuple.getValue();
            xmlResult = xmlResult + "</value>";
            xmlResult = xmlResult + "</tuple>";
        }
        xmlResult = xmlResult + "</forwardIndexResult>";
        logger.info((Object)xmlResult);
    }

    class UpdateXMLParser
    extends DefaultHandler {
        private static final String INSERT_ELEMENT = "INSERT";
        private static final String DELETE_ELEMENT = "DELETE";
        private static final String TUPLE_ELEMENT = "TUPLE";
        private static final String KEY_ELEMENT = "KEY";
        private static final String KEYNAME_ELEMENT = "KEYNAME";
        private static final String KEYVALUE_ELEMENT = "KEYVALUE";
        private static final String VALUE_ELEMENT = "VALUE";
        private static final String ID_ELEMENT = "ID";
        private ParserState currState = ParserState.IDLE;
        private StringBuffer currKeyName = new StringBuffer();
        private StringBuffer currKeyValue = new StringBuffer();
        private StringBuffer currValue = new StringBuffer();
        private StringBuffer currId = new StringBuffer();
        private Vector<String> keyNames = new Vector();
        private Vector<String> keyValues = new Vector();
        private boolean bDeletion = false;
        private boolean bKey;
        private Exception e = null;

        public void parse(String updateData) throws Exception {
            XMLReader xr = XMLReaderFactory.createXMLReader();
            xr.setContentHandler(this);
            xr.setErrorHandler(this);
            xr.setFeature("http://xml.org/sax/features/validation", false);
            xr.parse(new InputSource(new StringReader(updateData)));
            if (this.e != null) {
                throw this.e;
            }
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes atts) {
            boolean bError = false;
            if (qName.equalsIgnoreCase(INSERT_ELEMENT)) {
                if (this.currState.equals((Object)ParserState.IDLE)) {
                    this.currState = ParserState.IN_INSERT;
                    this.bDeletion = false;
                } else {
                    logger.error((Object)"Invalid XML data in rowset. INSERT was found in a wrong place");
                    bError = true;
                }
            } else if (qName.equalsIgnoreCase(DELETE_ELEMENT)) {
                if (this.currState.equals((Object)ParserState.IDLE)) {
                    this.currState = ParserState.IN_DELETE;
                    this.bDeletion = true;
                } else {
                    logger.error((Object)"Invalid XML data in rowset. DELETE was found in a wrong place");
                    bError = true;
                }
            } else if (qName.equalsIgnoreCase(TUPLE_ELEMENT)) {
                if (this.currState.equals((Object)ParserState.IN_INSERT) || this.currState.equals((Object)ParserState.IN_DELETE)) {
                    this.currState = ParserState.IN_TUPLE;
                } else {
                    logger.error((Object)"Invalid XML data in rowset. TUPLE was found in a wrong place");
                    bError = true;
                }
            } else if (qName.equalsIgnoreCase(KEY_ELEMENT)) {
                if (this.currState.equals((Object)ParserState.IN_TUPLE)) {
                    this.currState = ParserState.IN_KEY;
                } else {
                    logger.error((Object)"Invalid XML data in rowset. KEY was found in a wrong place");
                    bError = true;
                }
            } else if (qName.equalsIgnoreCase(KEYNAME_ELEMENT)) {
                if (this.currState.equals((Object)ParserState.IN_KEY)) {
                    if (this.bKey) {
                        logger.error((Object)"Invalid XML data in rowset. bkey is already set");
                        bError = true;
                    } else {
                        this.bKey = true;
                        this.currState = ParserState.IN_KEYNAME;
                    }
                } else {
                    bError = true;
                }
            } else if (qName.equalsIgnoreCase(KEYVALUE_ELEMENT)) {
                if (this.currState.equals((Object)ParserState.IN_KEY)) {
                    this.currState = ParserState.IN_KEYVALUE;
                } else {
                    logger.error((Object)"Invalid XML data in rowset. KEYVALUE was found in a wrong place");
                    bError = true;
                }
            } else if (qName.equalsIgnoreCase(VALUE_ELEMENT)) {
                if (this.currState.equals((Object)ParserState.IN_TUPLE)) {
                    this.currState = ParserState.IN_VALUE;
                } else {
                    logger.error((Object)"Invalid XML data in rowset. VALUE was found in a wrong place");
                    bError = true;
                }
            } else if (qName.equalsIgnoreCase(ID_ELEMENT)) {
                if (this.currState.equals((Object)ParserState.IN_TUPLE)) {
                    this.currState = ParserState.IN_ID;
                } else {
                    logger.error((Object)"Invalid XML data in rowset. ID was found in a wrong place");
                    bError = true;
                }
            }
            if (bError) {
                this.e = new Exception("Invalid XML in rowset data");
            }
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            boolean bError = false;
            if (qName.equalsIgnoreCase(INSERT_ELEMENT)) {
                if (this.currState.equals((Object)ParserState.IN_INSERT)) {
                    this.currState = ParserState.IDLE;
                } else {
                    logger.error((Object)"Invalid XML data in rowset. /INSERT was found in a wrong place");
                    bError = true;
                }
            } else if (qName.equalsIgnoreCase(DELETE_ELEMENT)) {
                if (this.currState.equals((Object)ParserState.IN_DELETE)) {
                    this.currState = ParserState.IDLE;
                } else {
                    logger.error((Object)"Invalid XML data in rowset. /DELETE was found in a wrong place");
                    bError = true;
                }
            } else if (qName.equalsIgnoreCase(TUPLE_ELEMENT)) {
                if (this.currState.equals((Object)ParserState.IN_TUPLE)) {
                    if (this.bDeletion) {
                        String _currId = this.currId.toString().trim();
                        if (this.keyNames.size() > 0 && _currId != null) {
                            try {
                                BDBWrapper.this.deleteTuple(this.keyNames, this.keyValues, _currId);
                            }
                            catch (Exception ex) {
                                logger.error((Object)ex.getMessage());
                                this.e = ex;
                            }
                        } else if (this.keyNames.size() == 0 && _currId != null) {
                            try {
                                BDBWrapper.this.deleteAllRefs(_currId);
                            }
                            catch (Exception ex) {
                                logger.error((Object)ex.getMessage());
                                this.e = ex;
                            }
                        } else {
                            logger.warn((Object)"Could not make deletion bacause the value ID to be deleted is null!");
                        }
                        this.currState = ParserState.IN_DELETE;
                    } else {
                        String _currValue = this.currValue.toString().trim();
                        if (this.keyNames.size() > 0 && _currValue != null) {
                            try {
                                Runtime rt = Runtime.getRuntime();
                                logger.debug((Object)("Trying to add Tuple---Max Memory: " + rt.maxMemory() + ", Total Memory: " + rt.totalMemory() + ", Free Memory: " + rt.freeMemory()));
                                BDBWrapper.this.addTuple(this.keyNames, this.keyValues, _currValue);
                                logger.debug((Object)"Just returned from addTuple");
                            }
                            catch (Exception ex) {
                                logger.error((Object)ex.getMessage());
                                this.e = ex;
                            }
                        } else {
                            logger.warn((Object)("Could not make insertion! keyNames.size()=" + this.keyNames.size() + " currValue='" + _currValue + "'"));
                        }
                        this.currState = ParserState.IN_INSERT;
                    }
                    this.keyNames.clear();
                    this.keyValues.clear();
                    this.currValue = new StringBuffer();
                    this.currId = new StringBuffer();
                } else {
                    bError = true;
                }
            } else if (qName.equalsIgnoreCase(KEY_ELEMENT)) {
                if (this.currState.equals((Object)ParserState.IN_KEY)) {
                    this.currState = ParserState.IN_TUPLE;
                    this.bKey = false;
                    if (this.currKeyValue.length() > 0 && this.currKeyName.length() > 0) {
                        this.keyNames.add(this.currKeyName.toString().trim());
                        this.keyValues.add(this.currKeyValue.toString().trim());
                    }
                    this.currKeyName = new StringBuffer();
                    this.currKeyValue = new StringBuffer();
                } else {
                    logger.error((Object)"Invalid XML data in rowset. /KEY was found in a wrong place");
                    bError = true;
                }
            } else if (qName.equalsIgnoreCase(KEYNAME_ELEMENT)) {
                if (this.currState.equals((Object)ParserState.IN_KEYNAME)) {
                    this.currState = ParserState.IN_KEY;
                } else {
                    logger.error((Object)"Invalid XML data in rowset. /KEYNAME was found in a wrong place");
                    bError = true;
                }
            } else if (qName.equalsIgnoreCase(KEYVALUE_ELEMENT)) {
                if (this.currState.equals((Object)ParserState.IN_KEYVALUE)) {
                    this.currState = ParserState.IN_KEY;
                } else {
                    logger.error((Object)"Invalid XML data in rowset. /KEYVALUE was found in a wrong place");
                    bError = true;
                }
            } else if (qName.equalsIgnoreCase(VALUE_ELEMENT)) {
                if (this.currState.equals((Object)ParserState.IN_VALUE)) {
                    this.currState = ParserState.IN_TUPLE;
                    Runtime rt = Runtime.getRuntime();
                } else {
                    logger.error((Object)"Invalid XML data in rowset. /VALUE was found in a wrong place");
                    bError = true;
                }
            } else if (qName.equalsIgnoreCase(ID_ELEMENT)) {
                if (this.currState.equals((Object)ParserState.IN_ID)) {
                    this.currState = ParserState.IN_TUPLE;
                } else {
                    logger.error((Object)"Invalid XML data in rowset. /ID was found in a wrong place");
                    bError = true;
                }
            }
            if (bError) {
                this.e = new Exception("Invalid XML in rowset data");
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.currState == ParserState.IN_KEYNAME) {
                this.currKeyName.append(ch, start, length);
            } else if (this.currState == ParserState.IN_KEYVALUE) {
                this.currKeyValue.append(ch, start, length);
            } else if (this.currState == ParserState.IN_VALUE) {
                this.currValue.append(ch, start, length);
            } else if (this.currState == ParserState.IN_ID) {
                this.currId.append(ch, start, length);
            }
        }

        @Override
        public void error(SAXParseException e1) {
            this.e = e1;
        }

        @Override
        public void fatalError(SAXParseException e1) {
            this.e = e1;
        }
    }

    private static enum ParserState {
        IDLE,
        IN_INSERT,
        IN_DELETE,
        IN_TUPLE,
        IN_KEY,
        IN_KEYNAME,
        IN_KEYVALUE,
        IN_VALUE,
        IN_ID;

    }
}

