/*
 * LemmatizerFactory.java
 *
 * $Author: tsakas $
 * $Date: 2007/12/20 14:37:39 $
 * $Id: LemmatizerFactory.java,v 1.1 2007/12/20 14:37:39 tsakas Exp $
 *
 * <pre>
 *             Copyright (c) : 2006 Fast Search & Transfer ASA
 *                             ALL RIGHTS RESERVED
 * </pre>
 */

package org.gcube.indexmanagement.common.linguistics.lemmatizerplugin;

import org.gcube.indexmanagement.common.IndexException;

import java.util.Vector;

/**
 * This class loads the real implementation of the lemmatizer.
 */
public class LemmatizerFactory {
    /**
     * Private constructor. This class can not be instantiated.
     */
    private LemmatizerFactory() {
    }

    /**
     *  This method loads the plugin for the language identifier and
     * calls the init  method with the configFile as a parameter.
     *  @param pluginName        The name of the plugin to be loaded.
     *                           The plugin must implement the
     *                           interface LanguageIdPlugin.
     *  @return                  The plugin loaded
     *  @throws IndexException   The IndexException is thrown in case the class
     *                           can not be loaded or initialized.
     */
    public static LemmatizerPlugin loadPlugin(String pluginName)
        throws IndexException  {

        //String pluginName = "FastLemmatizerPlugin";
        try {
//            System.out.println("LanguageIdFactory::loadPlugin loading: " + pluginName);
            LemmatizerPlugin lemmatizerPlugin =
                (LemmatizerPlugin)Class.forName(pluginName).newInstance();
            return lemmatizerPlugin;
        }
        catch(Exception e){
            throw new IndexException("Class load error, pluginName "
                                     + pluginName
                                     + " Exception: "
                                     + e.toString());
        }
    }
}

