/*
 * Language.java
 *
 * $Author: tsakas $
 * $Date: 2007/12/20 14:37:39 $
 * $Id: Language.java,v 1.1 2007/12/20 14:37:39 tsakas Exp $
 *
 * <pre>
 *             Copyright (c) : 2006 Fast Search & Transfer ASA
 *                             ALL RIGHTS RESERVED
 * </pre>
 */

package org.gcube.indexmanagement.common.linguistics.lemmatizerplugin;
/**
 * Enum to hold all supported languages.
 *
 */
public enum Language {
    /** Long and short form of the language. */
    af  ("AFRIKAANS", "af"),
    /** Long and short form of the language. */
    ar  ("ARABIC", "ar"),
    /** Long and short form of the language. */
    az  ("AZERI", "az"),
    /** Long and short form of the language. */
    be  ("BYELORUSSIAN", "be"),
    /** Long and short form of the language. */
    bg  ("BULGARIAN", "bg"),
    /** Long and short form of the language. */
    bn  ("BANGLA", "bn"),
    /** Long and short form of the language. */
    br  ("BRETON", "br"),
    /** Long and short form of the language. */
    bs  ("BOSNIAN", "bs"),
    /** Long and short form of the language. */
    ca  ("CATALAN", "ca"),
    /** Long and short form of the language. */
    cs  ("CZECH", "cs"),
    /** Long and short form of the language. */
    cy  ("WELSH", "cy"),
    /** Long and short form of the language. */
    da  ("DANISH", "da"),
    /** Long and short form of the language. */
    de  ("GERMAN", "de"),
    /** Long and short form of the language. */
    el  ("GREEK", "el"),
    /** Long and short form of the language. */
    en  ("ENGLISH", "en"),
    /** Long and short form of the language. */
    eo  ("ESPERANTO", "eo"),
    /** Long and short form of the language. */
    es  ("SPANISH", "es"),
    /** Long and short form of the language. */
    et  ("ESTONIAN", "et"),
    /** Long and short form of the language. */
    eu  ("BASQUE", "eu"),
    /** Long and short form of the language. */
    fa  ("FARSI", "fa"),
    /** Long and short form of the language. */
    fi  ("FINNISH", "fi"),
    /** Long and short form of the language. */
    fo  ("FAEROESE", "fo"),
    /** Long and short form of the language. */
    fr  ("FRENCH", "fr"),
    /** Long and short form of the language. */
    fy  ("FRISIAN", "fy"),
    /** Long and short form of the language. */
    ga  ("IRISH_GAELIC", "ga"),
    /** Long and short form of the language. */
    gl  ("GALICIAN", "gl"),
    /** Long and short form of the language. */
    ha  ("HAUSA", "ha"),
    /** Long and short form of the language. */
    he  ("HEBREW", "he"),
    /** Long and short form of the language. */
    hi  ("HINDI", "hi"),
    /** Long and short form of the language. */
    hr  ("CROATIAN", "hr"),
    /** Long and short form of the language. */
    hu  ("HUNGARIAN", "hu"),
    /** Long and short form of the language. */
    hy  ("ARMENIAN", "hy"),
    /** Long and short form of the language. */
    id  ("INDONESIAN", "id"),
    /** Long and short form of the language. */
    is  ("ICELANDIC", "is"),
    /** Long and short form of the language. */
    it  ("ITALIAN", "it"),
    /** Long and short form of the language. */
    ja  ("JAPANESE", "ja"),
    /** Long and short form of the language. */
    ka  ("GEORGIAN", "ka"),
    /** Long and short form of the language. */
    kk  ("KAZAKH", "kk"),
    /** Long and short form of the language. */
    kl  ("GREENLANDIC", "kl"),
    /** Long and short form of the language. */
    ko  ("KOREAN", "ko"),
    /** Long and short form of the language. */
    ku  ("KURDISH", "ku"),
    /** Long and short form of the language. */
    ky  ("KIRGHIZ", "ky"),
    /** Long and short form of the language. */
    la  ("LATIN", "la"),
    /** Long and short form of the language. */
    lb  ("LETZEBURGESCH", "lb"),
    /** Long and short form of the language. */
    lt  ("LITHUANIAN", "lt"),
    /** Long and short form of the language. */
    lv  ("LATVIAN", "lv"),
    /** Long and short form of the language. */
    mi  ("MAORI", "mi"),
    /** Long and short form of the language. */
    mn  ("MONGOLIAN", "mn"),
    /** Long and short form of the language. */
    ms  ("MALAY", "ms"),
    /** Long and short form of the language. */
    mt  ("MALTESE", "mt"),
    /** Long and short form of the language. */
    nb  ("NORWEGIAN_BOKMAAL", "nb"),
    /** Long and short form of the language. */
    nl  ("DUTCH", "nl"),
    /** Long and short form of the language. */
    nn  ("NORWEGIAN_NYNORSK", "nn"),
    /** Long and short form of the language. */
    pl  ("POLISH", "pl"),
    /** Long and short form of the language. */
    ps  ("PASHTO", "ps"),
    /** Long and short form of the language. */
    pt  ("PORTUGUESE", "pt"),
    /** Long and short form of the language. */
    rm  ("RHAETO_ROMANCE", "rm"),
    /** Long and short form of the language. */
    ro  ("ROMANIAN", "ro"),
    /** Long and short form of the language. */
    ru  ("RUSSIAN", "ru"),
    /** Long and short form of the language. */
    se  ("SAMI_NORTHERN", "se"),
    /** Long and short form of the language. */
    sk  ("SLOVAK", "sk"),
    /** Long and short form of the language. */
    sl  ("SLOVENIAN", "sl"),
    /** Long and short form of the language. */
    sq  ("ALBANIAN", "sq"),
    /** Long and short form of the language. */
    sr  ("SERBIAN", "sr"),
    /** Long and short form of the language. */
    sv  ("SWEDISH", "sv"),
    /** Long and short form of the language. */
    sw  ("SWAHILI", "sw"),
    /** Long and short form of the language. */
    ta  ("TAMIL", "ta"),
    /** Long and short form of the language. */
    th  ("THAI", "th"),
    /** Long and short form of the language. */
    tl  ("FILIPINO", "tl"),
    /** Long and short form of the language. */
    tr  ("TURKISH", "tr"),
    /** Long and short form of the language. */
    uk  ("UKRAINIAN", "uk"),
    /** Long and short form of the language. */
    ur  ("URDU", "ur"),
    /** Long and short form of the language. */
    uz  ("UZBEK", "uz"),
    /** Long and short form of the language. */
    vi  ("VIETNAMESE", "vi"),
    /** Long and short form of the language. */
    wen  ("SORBIAN", "en"),
    /** Long and short form of the language. */
    yi  ("YIDDISH", "yi"),
    /** Long and short form of the language. */
    zh_cn  ("CHINESE_SIMPLIFIED", "cn"),
    /** Long and short form of the language. */
    zh_tw  ("CHINESE_TRADITIONAL", "tw"),
    /** Long and short form of the language. */
    zu  ("ZULU", "zu"),
    /** Long and short form of the language. */
    no  ("NORWEGIAN", "no");

    /**
     * The long language string.
     */
    private final String longLanguageString;

    /**
     * The short language string.
     */
    private final String shortLanguageString;

    /**
     * The constructor, initializing the language string.
     * @param longL     The long language string
     * @param shortL     The short language string
     */
    private Language(final String longL, final String shortL) {
        this.longLanguageString = longL;
        this.shortLanguageString = shortL;
    }

    /**
     * Method to get the long language string.
     * @return     The long language string
     */
    public String toLongString() {
        return this.longLanguageString;
    }

    /**
     * Method to get the short language string.
     * @return     The short language string
     */
    public String toShortString() {
        return this.shortLanguageString;
    }
}
