package org.gcube.indexmanagement.featureindexlibrary.vafile.io;

import java.io.*;

import org.apache.log4j.Logger;
import org.gcube.indexmanagement.featureindexlibrary.commons.FileHelper;
import org.gcube.indexmanagement.featureindexlibrary.vafile.VAFileParams;
import org.gcube.indexmanagement.featureindexlibrary.vafile.elements.ApproximationFileEntry;
import org.gcube.indexmanagement.featureindexlibrary.vafile.elements.ApproximationFileEntryInfo;

/**
 * Approximation reader
 * 
 * @author UoA
 */
public class ApproximationFileReader {
	/**
	 * Logger used by the class
	 */
	private static Logger log = Logger.getLogger(ApproximationFileReader.class);
	/**
	 * The VAFile parameters
	 */
	private VAFileParams params=null;
	/**
	 * The input stream
	 */
	private FileInputStream fis=null;
	/**
	 * The input stream
	 */
	private BufferedInputStream bis=null;
	/**
	 * The input stream
	 */
	private DataInputStream dis=null;
	/**
	 * The io helper
	 */
	private IOHelper helper=null;
	/**
	 * The number of elements
	 */
	private int count=0;
	
	/**
	 * Creates a new Instance
	 * 
	 * @param params The VAFile header params
	 * @throws Exception An error
	 */
	public ApproximationFileReader(VAFileParams params) throws Exception{
		try{
			this.params=params;
			this.helper=new IOHelper();
			this.helper.setIDLength(params.getIDLength());
			this.helper.setVectorLength(params.getVectorLength());
			this.count=0;
		}catch(Exception e){
			log.error("Could not initialize reader. throwing Exception",e);
			throw new Exception("Could not initialize reader");
		}
	}
	
	/**
	 * Opens for reading
	 * 
	 * @throws Exception An error
	 */
	public void open() throws Exception{
		try{
			fis=new FileInputStream(FileHelper.getVAFApproxFile(params.getStorage(),params.getIndexID()));
			bis=new BufferedInputStream(fis);
			dis=new DataInputStream(bis);
		}catch(Exception e){
			log.error("Could not open reader. throwing Exception",e);
			throw new Exception("Could not open reader");
		}
	}
	
	/**
	 * Reads entry
	 * 
	 * @return The entry
	 */
	public ApproximationFileEntryInfo getNext(){
		ApproximationFileEntry entry=helper.readApproximation(dis);
		if(entry==null) return null;
		count+=1;
		if(entry.isActive()) return new ApproximationFileEntryInfo(entry,count-1);
		else return this.getNext();
	}
	
	/**
	 * Closes
	 * 
	 * @throws Exception An error
	 */
	public void close() throws Exception{
		try{
			this.dis.close();
			this.bis.close();
			this.fis.close();
		}catch(Exception e){
			log.error("Could not close reader. Throwing Exception",e);
			throw new Exception("Could not close reader");
		}
	}
}
