package org.gcube.indexmanagement.featureindexlibrary.fullscan;

import org.gcube.indexmanagement.featureindexlibrary.commons.FIEnums;

/**
 * Parameters for creating a full scan index
 * 
 * @author UoA
 */
public class FullScanParams {
	/**
	 * The indexed feature
	 */
	private String feature=null;
	/**
	 * Te default distnace used
	 */
	private FIEnums.DistanceTypes distance=null;
	/**
	 * The index id
	 */
	private String indexID=null;
	/**
	 * The storage directory
	 */
	private String storage=null;
	/**
	 * The index name
	 */
	private String indexName=null;
	/**
	 * The number of elements in the index
	 */
	private long elementCount=0;
	
	/**
	 * Creates a new instance
	 * 
	 * @param feature The feature
	 * @param distance The distance
	 */
	public FullScanParams(String feature,FIEnums.DistanceTypes distance){
		this.feature=feature;
		this.distance=distance;
		this.elementCount=0;
	}

	/**
	 * The number of elements
	 * 
	 * @return The number of elements
	 */
	public long getElementCount() {
		return elementCount;
	}

	/**
	 * Sets the number of elements
	 * 
	 * @param elementCount The number of elements
	 */
	public void setElementCount(long elementCount) {
		this.elementCount = elementCount;
	}

	/**
	 * Retrieves the index id
	 * 
	 * @return The index id
	 */
	public String getIndexID() {
		return indexID;
	}

	/**
	 * Sets the index id
	 * 
	 * @param indexID The index id
	 */
	public void setIndexID(String indexID) {
		this.indexID = indexID;
	}

	/**
	 * Retireves the storage location
	 * 
	 * @return The storage location
	 */
	public String getStorage() {
		return storage;
	}

	/**
	 * Sets the storage directory
	 * 
	 * @param storage The storage directory
	 */
	public void setStorage(String storage) {
		this.storage = storage;
	}

	/**
	 * Retrieves the index name
	 * 
	 * @return The index name
	 */
	public String getIndexName() {
		return indexName;
	}

	/**
	 * Sets the index name
	 * 
	 * @param indexName the index name
	 */
	public void setIndexName(String indexName) {
		this.indexName = indexName;
	}
	
	/**
	 * Retrieves the distance measure
	 * 
	 * @return The distance measure
	 */
	public FIEnums.DistanceTypes getDistanceMeasure() {
		return distance;
	}

	/**
	 * Sets the distance measure
	 * 
	 * @param distanceMeasure The distance measure
	 */
	public void setDistanceMeasure(FIEnums.DistanceTypes distanceMeasure) {
		this.distance = distanceMeasure;
	}

	/**
	 * Retrieves the feature name
	 * 
	 * @return The feature name
	 */
	public String getFeatureName() {
		return feature;
	}

	/**
	 * Sets the feature name
	 * 
	 * @param featureName The feature name
	 */
	public void setFeatureName(String featureName) {
		this.feature = featureName;
	}
}
