package org.gcube.indexmanagement.featureindexlibrary.commons;

import java.util.ArrayList;
import java.util.Collections;


/**
 * A Sorted heal utility
 * 
 * @author UoA
 */
public class SortedHeap {
	/**
	 * Buffer holding the elements
	 */
	private ArrayList<HeapElement> buffer=null;
	
	/**
	 * Creates a new instance
	 */
	public SortedHeap(){
		this.buffer=new ArrayList<HeapElement>();
	}
	
	/**
	 * Retrieves the number of results
	 * 
	 * @return The number of results
	 */
	public int getNumberOfElements(){
		return this.buffer.size();
	}
	
	/**
	 * Retrieves the elment in the given position
	 * 
	 * @param i The index of the elmnt to retrieve
	 * @return The element
	 */
	public HeapElement get(int i){
		return this.buffer.get(i);
	}
	
	/**
	 * Adds the element
	 * 
	 * @param element The elment
	 */
	public void add(HeapElement element){
		this.addToBuffer(element);
	}
	
	/**
	 * Sorts the existing elements
	 */
	public void sort(){
		Collections.sort(this.buffer,new SortAscHeapElementComparator());
	}
	
	/**
	 * Adds the given elment to buffer
	 * 
	 * @param element The elment to add
	 */
	private void addToBuffer(HeapElement element){
		this.buffer.add(element);
//		Collections.sort(this.buffer,new SortAscHeapElementComparator());
	}
}
