package org.gcube.indexmanagement.featureindexlibrary.commons;

/**
 * Element holding rank info
 * 
 * @author UoA
 */
public class RankedResultElement {
	/**
	 * The id
	 */
	private String id=null;
	/**
	 * The rank
	 */
	private float rank=0;
	/**
	 * The index name
	 */
	private String indexName=null;
	
	/**
	 * Creates a new instance
	 * 
	 * @param id The id
	 * @param rank The rank
	 */
	public RankedResultElement(String id, float rank){
		this.id=id;
		this.rank=rank;
		this.indexName=null;
	}

	/**
	 * The id
	 * 
	 * @return The id
	 */
	public String getId() {
		return id;
	}

	/**
	 * Sets the id
	 * 
	 * @param id The id
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * Retrieves the rank
	 * 
	 * @return The rank
	 */
	public float getRank() {
		return rank;
	}

	/**
	 * Sets the rank
	 * 
	 * @param rank the rank
	 */
	public void setRank(float rank) {
		this.rank = rank;
	}
	
	/**
	 * Sets the index name
	 * 
	 * @param indexName The index name
	 */
	public void setIndexName(String indexName){
		this.indexName=indexName;
	}
	
	/**
	 * Retrieves the index name
	 * 
	 * @return the index name
	 */
	public String getIndexName(){
		return this.indexName;
	}
}
