/**
 * 
 */
package org.gcube.indexmanagement.common;

import org.gcube.common.core.informationsystem.notifier.ISNotifier.BaseNotificationConsumer;
import org.gcube.common.core.informationsystem.notifier.ISNotifier.NotificationEvent;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;

/**
 * @author Spyros Boutsis, NKUA
 */
public abstract class IndexNotificationConsumer extends BaseNotificationConsumer {
	
	static GCUBELog logger = new GCUBELog(IndexNotificationConsumer.class);
	
	private IndexWSResource resource;
	private GCUBEScope scope;
	
	public IndexNotificationConsumer(IndexWSResource consumerResource, GCUBEScope notificationScope) {
		this.resource = consumerResource;
		this.scope = notificationScope;
	}
	
	protected final void onNotificationReceived(NotificationEvent event) {
		try {
			logger.info("IndexNotificationConsumer received notification, setting ServiceContext scope...");
			resource.getServiceContext().setScope(scope);
			logger.info("Dispatching notification to custom consumer.");
			this.onNewNotification(event);
		} catch (Exception e) {
			logger.error("Error while handling received notification.", e);
		}
	}

	protected abstract void onNewNotification(NotificationEvent event);
}
