package org.gcube.indexmanagement.featureindexlibrary.commons;

import java.util.Comparator;

/**
 * Comparator for sorting in ascending order {@link org.gcube.indexmanagement.featureindexlibrary.commons.RankedResultElement} 
 * 
 * @author UoA
 */
public class SortAscRankedResultComparator implements Comparator{
	/**
	 * compares the two instances
	 * 
	 * @param o1 The left operant
	 * @param o2 The right operant
	 * @return The result of the comparison
	 */
	public int compare(Object o1, Object o2){
		if(!(o1 instanceof RankedResultElement)) throw new ClassCastException();
		if(!(o2 instanceof RankedResultElement)) throw new ClassCastException();
		try{
	    	if(((RankedResultElement)o1).getRank()>((RankedResultElement)o2).getRank()) return 1;
	    	else if(((RankedResultElement)o1).getRank()<((RankedResultElement)o2).getRank()) return -1;
	    	else return 0;
		}catch(Exception e){
			throw new ClassCastException("INvalid Token Format Comparison");
		}
	}
	
	/**
	 * @see java.lang.Object#equals(java.lang.Object)
	 * @param o The object to check for comparison
	 * @return the result of the equality check
	 */
	public boolean equals(Object o){
	    if(!(o instanceof SortAscRankedResultComparator))
	        return false;
	    else return true;
	  }
}
