/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.featureindexlibrary.vafile.algo;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.gcube.indexmanagement.featureindexlibrary.commons.FeatureVectorElement;
import org.gcube.indexmanagement.featureindexlibrary.vafile.VAFileParams;
import org.gcube.indexmanagement.featureindexlibrary.vafile.io.FileBufferReader;

public class PointPartitioning {
    private static Logger log = Logger.getLogger(PointPartitioning.class);
    private String file = null;
    private VAFileParams params = null;
    private float[][] partitionPoints = null;

    public PointPartitioning(String file, VAFileParams params) {
        this.file = file;
        this.params = params;
    }

    public int getPartitionBuckets() {
        int buckets = (int)Math.pow(2.0, this.params.getBits());
        return buckets + 1;
    }

    public float[][] getPartitionPoints() {
        return this.partitionPoints;
    }

    public void computePartitionPoints() throws Exception {
        try {
            this.partitionPoints = new float[this.params.getVectorLength()][];
            for (int i = 0; i < this.params.getVectorLength(); ++i) {
                this.partitionPoints[i] = this.computePartitionPoints(i);
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not compute partition points. Throwing Exception", (Throwable)e);
            throw new Exception("Could not compute partition points");
        }
    }

    private float[] computePartitionPoints(int dim) throws Exception {
        try {
            int i;
            int buckets = (int)Math.pow(2.0, this.params.getBits());
            float[] points = new float[buckets + 1];
            ArrayList<Float> vectordim = new ArrayList<Float>();
            FileBufferReader reader = new FileBufferReader(this.file, this.params);
            reader.openForReading();
            FeatureVectorElement elem = null;
            while ((elem = reader.readElement()) != null) {
                vectordim.add(new Float(elem.getVector()[dim]));
            }
            reader.close();
            Collections.sort(vectordim);
            int count = vectordim.size() / buckets;
            points[0] = ((Float)vectordim.get(0)).floatValue();
            points[points.length - 1] = ((Float)vectordim.get(vectordim.size() - 1)).floatValue();
            int[] indexes = new int[buckets - 1];
            for (int i2 = 0; i2 < indexes.length; ++i2) {
                indexes[i2] = (i2 + 1) * count;
            }
            int addition = 0;
            for (i = 0; i < vectordim.size() - buckets * count; ++i) {
                int n = i;
                indexes[n] = indexes[n] + (i + 1);
                addition = i + 1;
            }
            i = vectordim.size() - buckets * count;
            while (i < indexes.length) {
                int n = i++;
                indexes[n] = indexes[n] + addition;
            }
            for (i = 1; i < buckets; ++i) {
                if (indexes[i - 1] >= vectordim.size()) {
                    indexes[i - 1] = vectordim.size() - 1;
                }
                points[i] = ((Float)vectordim.get(indexes[i - 1])).floatValue();
            }
            return points;
        }
        catch (Exception e) {
            log.error((Object)("Could not compute partition points for dimention " + dim + ". Throwing exception"), (Throwable)e);
            throw new Exception("Could not compute partition points for dimention " + dim);
        }
    }
}

