package org.gcube.indexmanagement.featureindexlibrary.vafile.io;

import java.io.RandomAccessFile;

import org.apache.log4j.Logger;
import org.gcube.indexmanagement.featureindexlibrary.commons.FileHelper;
import org.gcube.indexmanagement.featureindexlibrary.vafile.VAFileParams;
import org.gcube.indexmanagement.featureindexlibrary.vafile.elements.VectorFileEntry;

/**
 * Vector File random access
 * 
 * @author UoA
 */
public class VectorFileRandomAccess {
	/**
	 * The Logger this class uses
	 */
	private static Logger log = Logger.getLogger(VectorFileRandomAccess.class);
	/**
	 * The VAFile header params
	 */
	private VAFileParams params=null;
	/**
	 * The file access
	 */
	private RandomAccessFile rand=null;
	/**
	 * The IO helper
	 */
	private IOHelper helper=null;
	/**
	 * Starting offset
	 */
	private long startOffset=0;
	
	/**
	 * Creates a new instance
	 * 
	 * @param params Teh VAFile parameters
	 * @throws Exception An error
	 */
	public VectorFileRandomAccess(VAFileParams params) throws Exception{
		this.params=params;
		this.helper=new IOHelper();
		helper.setIDLength(params.getIDLength());
		helper.setVectorLength(params.getVectorLength());
	}
	
	/**
	 * Opens
	 * 
	 * @throws Exception An error
	 */
	public void open() throws Exception{
		try{
			rand=new RandomAccessFile(FileHelper.getVAFVectorFile(params.getStorage(),params.getIndexID()),"rw");
			helper.skipHeader(rand);
			this.startOffset=rand.getFilePointer();
		}catch(Exception e){
			log.error("Could not create reader, Throwing Exception",e);
			throw new Exception("Could not create reader");
		}
	}
	
	/**
	 * Move to the specified record
	 * 
	 * @param recNum The record number
	 * @throws Exception An error
	 */
	public void moveTo(long recNum) throws Exception{
		try{
			rand.seek(this.startOffset+(recNum*params.getVectorEntryLength()));
		}catch(Exception e){
			log.error("Could not seek to record "+recNum+". Throwing Exception",e);
			throw new Exception("Could not seek to record "+recNum);
		}
	}
	
	/**
	 * Writes an entry
	 * 
	 * @param entry The entry
	 * @throws Exception An error
	 */
	public void write(VectorFileEntry entry) throws Exception{
		if(entry.getVector().length!=params.getVectorLength() || entry.getId().length()!=params.getIDLength()){
			throw new Exception("new entry dimentions don't match");
		}
		try{
			this.helper.writeRecord(entry,rand);
		}catch(Exception e){
			log.error("Could not write record. Throwing Exception",e);
			throw new Exception("Could not write record"); 
		}
	}
	
	/**
	 * Reads an entry
	 * 
	 * @return The entry
	 * @throws Exception An error
	 */
	public VectorFileEntry read() throws Exception{
		try{
			return helper.readRecord(rand);
		}catch(Exception e){
			log.error("Could not read record. Throwing Exception",e);
			throw new Exception("Could not read record");
		}
	}
	
	/**
	 * Closes
	 * 
	 * @throws Exception An error
	 */
	public void close() throws Exception{
		try{
			rand.close();
		}catch(Exception e){
			log.error("Could not close reader. Throwing Exception",e);
			throw new Exception("Could not close reader");
		}
	}
}
