/**
 * 
 */
package org.gcube.indexmanagement.common.notifications;

import java.util.LinkedList;
import java.util.List;

import javax.xml.namespace.QName;

import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.informationsystem.notifier.ISNotifier;
import org.gcube.common.core.informationsystem.notifier.ISNotifier.GCUBENotificationTopic;
import org.gcube.common.core.scope.GCUBEScope;

/**
 * @author Spyros Boutsis, NKUA
 *
 */
public class UnsubscribeFromNotificationRequest extends NotifierRequest {

	private List<QName> topicList;
	
	public UnsubscribeFromNotificationRequest(List<QName> topicList, GCUBEServiceContext sctx, GCUBEScope scope) {
		super(null, sctx, scope);
		this.topicList = new LinkedList<QName>(topicList);
	}
	
	/* (non-Javadoc)
	 * @see org.gcube.indexmanagement.common.notifications.NotifierRequest#doRequest()
	 */
	@Override
	public void doRequest() {
		ISNotifier notifier = NotifierRequestQueue.getInstance().getNotifier();
		//construct the list with the topics
		List<GCUBENotificationTopic> topics = new LinkedList<GCUBENotificationTopic>();
		for(int i=0; i<topicList.size(); i++)
		{
			GCUBENotificationTopic topic = new GCUBENotificationTopic(topicList.get(i));
			//receive past notifications, sent before subscription - meaningless in this case
			topic.setUseRenotifier(true);
			topics.add(topic);
		}
		
		try {
			notifier.unregisterFromISNotification(this.sctx, topics, this.scope);
		} catch (Exception e) {
			logger.warn("Exception while trying to unsubscribe from topics.", e);
			try {
				Thread.sleep(5000);
			} catch (InterruptedException ex) { }
		}
	}

}
