/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.lucenewrapper;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.queryParser.QueryParser;
import org.gcube.indexmanagement.common.linguistics.lemmatizerplugin.Language;
import org.gcube.indexmanagement.lucenewrapper.LuceneSearcher;

public class ParserTesting {
    public static void main(String[] args) {
        try {
            StandardAnalyzer analyzer = new StandardAnalyzer();
            QueryParser defaultParser = new QueryParser("_contents", (Analyzer)analyzer);
            LuceneSearcher ls = new LuceneSearcher("org.gcube.indexmanagement.common.linguistics.lemmatizerplugin.SnowballStemmingPlugin", "/have/no/idea", Language.en);
            ls.fieldNames.add("foo_field");
            String queryString = "_querylang_en: \"europe and asia\" AND cats";
            Boolean onlyLemmatize = false;
            String defaultLang = "en";
            if (queryString.startsWith("_querylang_") || queryString.startsWith("_querylemlang_")) {
                int langStart;
                if (queryString.startsWith("_querylang_")) {
                    langStart = 11;
                    onlyLemmatize = false;
                } else {
                    langStart = 14;
                    onlyLemmatize = true;
                }
                int prefixEnd = queryString.indexOf(58);
                defaultLang = queryString.substring(langStart, prefixEnd);
                System.out.println("Default lang = " + defaultLang);
                queryString = queryString.substring(prefixEnd + 1);
            }
            String ex_query = ls.expandQuery(queryString, defaultLang, defaultLang, onlyLemmatize);
            System.out.println("Query: " + queryString);
            System.out.println("XQuery: " + ex_query);
            System.out.println("Query: " + queryString);
            System.out.println("Test OK");
        }
        catch (Exception e) {
            if (e.getMessage().contains("Cannot parse '':")) {
                System.out.println("Empty Query String");
            }
            e.printStackTrace();
            System.out.println("Test Failed");
        }
    }
}

