/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.common.notifications;

import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.informationsystem.notifier.ISNotifier;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.indexmanagement.common.notifications.NotifierRequest;
import org.gcube.indexmanagement.common.notifications.NotifierRequestQueue;

public class UnsubscribeFromNotificationRequest
extends NotifierRequest {
    private List<QName> topicList;

    public UnsubscribeFromNotificationRequest(List<QName> topicList, GCUBEServiceContext sctx, GCUBEScope scope) {
        super(null, sctx, scope);
        this.topicList = new LinkedList<QName>(topicList);
    }

    @Override
    public void doRequest() {
        ISNotifier notifier = NotifierRequestQueue.getInstance().getNotifier();
        LinkedList<ISNotifier.GCUBENotificationTopic> topics = new LinkedList<ISNotifier.GCUBENotificationTopic>();
        for (int i = 0; i < this.topicList.size(); ++i) {
            ISNotifier.GCUBENotificationTopic topic = new ISNotifier.GCUBENotificationTopic(this.topicList.get(i));
            topic.setUseRenotifier(true);
            topics.add(topic);
        }
        try {
            notifier.unregisterFromISNotification((GCUBESecurityManager)this.sctx, topics, new GCUBEScope[]{this.scope});
        }
        catch (Exception e) {
            logger.warn((Object)"Exception while trying to unsubscribe from topics.", (Throwable)e);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
    }
}

