package org.gcube.indexmanagement.featureindexlibrary.fullscan;

import java.io.*;

import org.apache.log4j.Logger;
import org.gcube.indexmanagement.featureindexlibrary.commons.*;

/**
 * A reader of a full scan file
 * 
 * @author UoA
 */
public class FullScanReader {
	/**
	 * The logger used by the class
	 */
	private static Logger log = Logger.getLogger(FullScanReader.class);
	/**
	 * File access to the full scan
	 */
	private FileInputStream fis=null;
	/**
	 * Buffered stream
	 */
	private BufferedInputStream bis=null;
	/**
	 * Data stram
	 */
	private DataInputStream ds=null;
	
	/**
	 * Reads a string from the pointer
	 * 
	 * @return The string
	 * @throws Exception An error
	 */
	private String getString() throws Exception{
		int count=ds.readInt();
		char []charA=new char[count];
		for(int i=0;i<count;i+=1){
			charA[i]=ds.readChar();
		}
		String ret=new String(charA);
		if(ret.startsWith("-")) return "";
		return ret;
	}
	
	/**
	 * Reads a vector from the pointer
	 * 
	 * @return The vector
	 * @throws Exception An error
	 */
	private float []getVector() throws Exception{
		int count=ds.readInt();
		float []vector=new float[count];
		for(int i=0;i<count;i+=1){
			vector[i]=ds.readFloat();
		}
		return vector;
	}

	/**
	 * Creates a new instance
	 * 
	 * @param file The file
	 * @throws Exception An error
	 */
	public FullScanReader(String file) throws Exception{
		try{
			fis=new FileInputStream(file);
			bis=new BufferedInputStream(fis);
			ds=new DataInputStream(bis);
		}catch(Exception e){
			log.error("Could not initialize reader. thrpowing exception",e);
			throw new Exception("Could not initialize reader");
		}
	}
	
	/**
	 * Reads the head of the full scan file
	 * 
	 * @return The head
	 * @throws Exception An error
	 */
	public FullScanParams getCharacteristics() throws Exception{
		try{
			long elementCount=ds.readLong();
			String distanceMeasure=this.getString();
			String featureName=this.getString();
			String indexID=this.getString();
			String indexName=this.getString();
			String storage=this.getString();
			FullScanParams charact=new FullScanParams(featureName,FIEnums.DistanceTypes.valueOf(distanceMeasure));
			charact.setElementCount(elementCount);
			charact.setIndexID(indexID);
			charact.setIndexName(indexName);
			charact.setStorage(storage);
			return charact;
		}catch(Exception e){
			log.error("Could not retrieve charachteristics. thrpowing exception",e);
			throw new Exception("Could not retrieve charachteristics");
		}
	}
	
	/**
	 * Reads a record element
	 * 
	 * @return The record
	 */
	public FeatureVectorElement getElement(){
		try{
			while(true){
				String id=this.getString();
				float []vector=this.getVector();
				if(id.length()!=0) return new FeatureVectorElement(id,vector);
			}
		}catch(EOFException e){
			return null;
		}catch(Exception e){
			log.debug("Could not read element. assuming eof",e);
			return null;
		}
	}
	
	/**
	 * Closes the reader
	 * 
	 * @throws Exception An error
	 */
	public void close() throws Exception{
		try{
			this.fis.close();
			this.bis.close();
			this.ds.close();
		}catch(Exception e){
			log.error("Could not close reader. Throwing Exception",e);
			throw new Exception("Could not close reader");
		}
	}
}
