/*
 * SynonymFactory.java
 *
 * $Author: tsakas $
 * $Date: 2007/12/20 14:37:40 $
 * $Id: SynonymFactory.java,v 1.1 2007/12/20 14:37:40 tsakas Exp $
 *
 * <pre>
 *             Copyright (c) : 2006 Fast Search & Transfer ASA
 *                             ALL RIGHTS RESERVED
 * </pre>
 */
package org.gcube.indexmanagement.common.linguistics.synonymplugin;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.File;
import java.net.URLClassLoader;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.gcube.common.core.utils.logging.GCUBELog;


/**
 * Factory for loading the synonym plugin.
 */
final class SynonymFactory {

	/** logger */
	static GCUBELog logger = new GCUBELog(SynonymFactory.class);
	
    /**
     * Private constructor. This class can not be instantiated.
     */
    private SynonymFactory() {
    }

    /**
     *  This method delivers back an instance of the SynonymPlugin plugin.
     *  The langid plugin identify the language.
     *  @param config        The config file.
     *  @return              The synonym plugin instanciated.
     */
   public static SynonymPlugin loadPlugin(final File config) {
        String configtxt = "";
        String line = "";
        String pluginName = "";
        String pluginPath = "";

        Pattern p =
            Pattern.compile("<ModuleName>(.+?)</ModuleName><ModulePath>(.+?)</ModulePath>");
        Object tmpPlugin = new Object();
        try {
            BufferedReader fileInput
                = new BufferedReader(new FileReader(config));
            while (line != null) {
                configtxt += line;
                line = fileInput.readLine();
            }

            Matcher m = p.matcher(configtxt);

            // We need to figure out exactly what
            // the config-file should/can contain
            // Ask Dagfinn and change the regexp accordingly.
            if (m.find()) {
                pluginName = m.group(1);
                pluginPath = m.group(2);
            } else {
                return null;
            }

            File pluginPathFile = new File(pluginPath);
            URLClassLoader loader =
                new URLClassLoader(new URL[] {pluginPathFile.toURL()});
            Class x = loader.loadClass(pluginName);
            tmpPlugin = x.newInstance();

        } catch (Exception e) {
            logger.error("Error while loading SynonymPlugin", e);
            return null;
        }
        return (SynonymPlugin) tmpPlugin;
    }
}
