package org.gcube.indexmanagement.common;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * A class used primarily in the initialize(String args[]) method of GeoIndexLookup plugins
 * (rankers & refiners) in order to parse <code>String</code> arguments containing dates in the
 * format "yyyy-MM-dd'T'HH:mm:ss.s" (where only yyyy is mandatory) into Date instances.
 * @see org.gcube.indexmanagement.geo.refinement.Refiner
 * @see org.gcube.indexmanagement.geo.ranking.RankEvaluator
 *
 * @version 0.1
 */
public class DateParser {/**

     * A method used primarily in the initialize(String args[]) method of GeoIndexLookup plugins
     * (rankers & refiners) in order to parse <code>String</code> arguments containing dates in the
     * format "yyyy-MM-dd'T'HH:mm:ss.s" (where only yyyy is mandatory) into Date instances.
     * (where only yyyy is mandatory) into Date instances.
     * @param dateString - The date string to parse and produce a date.
     * @return - the parsed Date.
     * @throws ParseException - in case of a parse error.
     * @see org.gcube.indexmanagement.geo.refinement.Refiner
     * @see org.gcube.indexmanagement.geo.ranking.RankEvaluator
     *
     * @version 0.1
     */
    public static Date parse(String dateString) throws ParseException{
        try{
            SimpleDateFormat format = new java.text.SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.s");
            Date date = format.parse(dateString);
            return date;
        }
        catch(ParseException e){
        }
        try{
            SimpleDateFormat format = new java.text.SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            Date date = format.parse(dateString);
            return date;
        }
        catch(ParseException e){
        }
        try{
            SimpleDateFormat format = new java.text.SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
            Date date = format.parse(dateString);
            return date;
        }
        catch(ParseException e){
        }
        try{
            SimpleDateFormat format = new java.text.SimpleDateFormat("yyyy-MM-dd'T'HH");
            Date date = format.parse(dateString);
            return date;
        }
        catch(ParseException e){
        }
        try{
            SimpleDateFormat format = new java.text.SimpleDateFormat("yyyy-MM-dd");
            Date date = format.parse(dateString);
            return date;
        }
        catch(ParseException e){
        }
        try{
            SimpleDateFormat format = new java.text.SimpleDateFormat("yyyy-MM");
            Date date = format.parse(dateString);
            return date;
        }
        catch(ParseException e){
        }
        try{
            SimpleDateFormat format = new java.text.SimpleDateFormat("yyyy");
            Date date = format.parse(dateString);
            return date;
        }
        catch(ParseException e){
            throw e;
        }
    }
}
