/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.featureindexlibrary.vafile.io;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import org.apache.log4j.Logger;
import org.gcube.indexmanagement.featureindexlibrary.commons.FileHelper;
import org.gcube.indexmanagement.featureindexlibrary.vafile.VAFileParams;
import org.gcube.indexmanagement.featureindexlibrary.vafile.elements.ApproximationFileEntry;
import org.gcube.indexmanagement.featureindexlibrary.vafile.elements.ApproximationFileEntryInfo;
import org.gcube.indexmanagement.featureindexlibrary.vafile.io.IOHelper;

public class ApproximationFileReader {
    private static Logger log = Logger.getLogger(ApproximationFileReader.class);
    private VAFileParams params = null;
    private FileInputStream fis = null;
    private BufferedInputStream bis = null;
    private DataInputStream dis = null;
    private IOHelper helper = null;
    private int count = 0;

    public ApproximationFileReader(VAFileParams params) throws Exception {
        try {
            this.params = params;
            this.helper = new IOHelper();
            this.helper.setIDLength(params.getIDLength());
            this.helper.setVectorLength(params.getVectorLength());
            this.count = 0;
        }
        catch (Exception e) {
            log.error((Object)"Could not initialize reader. throwing Exception", (Throwable)e);
            throw new Exception("Could not initialize reader");
        }
    }

    public void open() throws Exception {
        try {
            this.fis = new FileInputStream(FileHelper.getVAFApproxFile(this.params.getStorage(), this.params.getIndexID()));
            this.bis = new BufferedInputStream(this.fis);
            this.dis = new DataInputStream(this.bis);
        }
        catch (Exception e) {
            log.error((Object)"Could not open reader. throwing Exception", (Throwable)e);
            throw new Exception("Could not open reader");
        }
    }

    public ApproximationFileEntryInfo getNext() {
        ApproximationFileEntry entry = this.helper.readApproximation(this.dis);
        if (entry == null) {
            return null;
        }
        ++this.count;
        if (entry.isActive()) {
            return new ApproximationFileEntryInfo(entry, this.count - 1);
        }
        return this.getNext();
    }

    public void close() throws Exception {
        try {
            this.dis.close();
            this.bis.close();
            this.fis.close();
        }
        catch (Exception e) {
            log.error((Object)"Could not close reader. Throwing Exception", (Throwable)e);
            throw new Exception("Could not close reader");
        }
    }
}

