/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.index.common.entities;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.rest.index.common.entities.ExternalEndpointInfo;
import org.gcube.rest.index.common.entities.configuration.CollectionStatus;
import org.gcube.rest.index.common.entities.configuration.DatasourceType;
import org.gcube.rest.index.common.entities.fields.Field;
import org.gcube.rest.index.common.entities.fields.config.FieldConfig;
import org.gcube.rest.index.common.entities.fields.config.StopwordLang;

@XmlRootElement
public class CollectionInfo {
    private String id;
    private String collectionDomain;
    private String title;
    private String description;
    private Date date;
    private CollectionStatus status;
    private ExternalEndpointInfo endpoint;
    private DatasourceType datasourceType;
    private Set<Field> collectionFields;
    private Map<String, FieldConfig> collectionFieldsConfigs;
    private Set<StopwordLang> stopwords;

    private CollectionInfo() {
    }

    public CollectionInfo(String id, String collectionDomain, DatasourceType type) {
        this(id, collectionDomain, type, null, null, null);
    }

    public CollectionInfo(String id, String collectionDomain, DatasourceType datasourceType, String title, String description, Date date) {
        this.id = id.toLowerCase();
        this.setCollectionDomain(collectionDomain);
        this.title = title;
        this.description = description;
        this.date = date == null ? new Date() : date;
        this.datasourceType = datasourceType;
        this.collectionFields = new HashSet<Field>();
        this.collectionFieldsConfigs = new HashMap<String, FieldConfig>();
        this.stopwords = new HashSet<StopwordLang>();
        this.status = CollectionStatus.OK;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Set<Field> getCollectionFields() {
        return this.collectionFields;
    }

    public void setCollectionFields(Set<Field> collectionFields) {
        this.collectionFields = collectionFields;
    }

    public String getCollectionDomain() {
        return this.collectionDomain;
    }

    public void setCollectionDomain(String collectionDomain) {
        this.collectionDomain = collectionDomain;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public DatasourceType getDatasourceType() {
        return this.datasourceType;
    }

    public void setDatasourceType(DatasourceType datasourceType) {
        this.datasourceType = datasourceType;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Map<String, FieldConfig> getCollectionFieldsConfigs() {
        return this.collectionFieldsConfigs;
    }

    public void setCollectionFieldsConfigs(Map<String, FieldConfig> collectionFieldsConfigs) {
        this.collectionFieldsConfigs = collectionFieldsConfigs;
    }

    public Map<String, String> getCollectionFieldsAliases() {
        HashMap<String, String> aliases = new HashMap<String, String>();
        if (this.collectionFieldsConfigs == null) {
            return aliases;
        }
        for (Map.Entry<String, FieldConfig> entry : this.collectionFieldsConfigs.entrySet()) {
            aliases.put(entry.getKey(), entry.getValue().getFieldNameAlias());
        }
        return aliases;
    }

    public void setCollectionFieldsAliases(Map<String, String> aliases) {
        if (this.collectionFieldsConfigs == null) {
            this.collectionFieldsConfigs = new HashMap<String, FieldConfig>();
        }
        for (Map.Entry<String, String> entry : aliases.entrySet()) {
            FieldConfig fc = this.collectionFieldsConfigs.get(entry.getKey());
            if (fc == null) {
                this.collectionFieldsConfigs.put(entry.getKey(), new FieldConfig(entry.getValue()));
                continue;
            }
            this.collectionFieldsConfigs.get(entry.getKey()).setFieldNameAlias(entry.getValue());
        }
    }

    public ExternalEndpointInfo getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(ExternalEndpointInfo endpoint) {
        this.endpoint = endpoint;
    }

    public Set<StopwordLang> getStopwords() {
        return this.stopwords;
    }

    public void setStopwords(Set<StopwordLang> stopwords) {
        this.stopwords = stopwords;
    }

    public CollectionStatus getStatus() {
        return this.status;
    }

    public void setStatus(CollectionStatus status) {
        this.status = status;
    }

    public boolean isValid() {
        return this.id != null && !this.id.isEmpty() && this.collectionDomain != null && !this.collectionDomain.isEmpty() && this.datasourceType != null;
    }

    public String toString() {
        return "[\tid: " + this.id + "\ncollectionDomain: " + this.collectionDomain + "\nTitle: " + this.title + "\nDescription: " + this.description + "\nDate: " + this.date + "\nDatasourceType: " + (Object)((Object)this.datasourceType) + "\ncollectionFields: " + this.collectionFields.toString() + "\ncollectionFieldsConfigs" + this.collectionFieldsConfigs.toString() + "\ncollectionStatus: " + this.status.toString() + "\n]";
    }
}

