/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.index.common.discover;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.rest.index.common.discover.IndexDiscovererAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexDiscoverer
implements IndexDiscovererAPI {
    private static final Logger logger = LoggerFactory.getLogger(IndexDiscoverer.class);

    @Override
    public Set<String> discoverFulltextIndexNodesOfThisAndAllOtherVres(String vreScope) {
        String voScope = IndexDiscoverer.getVO(vreScope);
        return this.discoverFulltextIndexNodes(voScope);
    }

    @Override
    public Set<String> discoverFulltextIndexNodes(String scope) {
        ScopeProvider.instance.set(scope);
        XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
        query.addCondition("$resource/Profile/ServiceClass/text() eq 'Index'").addCondition("$resource/Profile/ServiceName/text() eq 'FullTextIndexNode'");
        DiscoveryClient client = ICFactory.clientFor(GCoreEndpoint.class);
        List eprs = client.submit((Query)query);
        HashSet<String> clusterHosts = new HashSet<String>();
        for (GCoreEndpoint epr : eprs) {
            if (!"ready".equals(epr.profile().deploymentData().status().toLowerCase())) continue;
            for (GCoreEndpoint.Profile.Endpoint e : epr.profile().endpointMap().values().toArray(new GCoreEndpoint.Profile.Endpoint[epr.profile().endpointMap().values().size()])) {
                if (e.uri().toString().endsWith("/gcube/resource")) continue;
                clusterHosts.add(e.uri().toString());
            }
        }
        logger.info("Discovered on scope: " + scope + " the index cluster nodes: " + Arrays.toString(clusterHosts.toArray()));
        return clusterHosts;
    }

    public static String getVO(String vre) {
        if (vre.split("/+").length <= 3) {
            return vre;
        }
        vre = vre.substring(1);
        String[] splits = vre.split("/+");
        String vo = "";
        for (int i = 0; i < splits.length - 1; ++i) {
            vo = vo + "/" + splits[i];
        }
        if (vo.isEmpty()) {
            vo = "/";
        }
        return vo;
    }

    public static void main(String[] args) {
        Set<String> endpoints = new IndexDiscoverer().discoverFulltextIndexNodes("/gcube/devsec/devVRE");
        System.out.println(Arrays.toString(endpoints.toArray()));
    }
}

