/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.index.client.cache;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gcube.rest.index.client.exceptions.NoAvailableIndexServiceInstance;
import org.gcube.rest.index.client.globals.EndpointProvider;
import org.gcube.rest.index.common.entities.CollectionInfo;
import org.gcube.rest.index.common.search.Query;
import org.gcube.rest.index.common.search.Search_Response;
import org.gcube.rest.index.common.tools.Toolbox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.Cacheable;

public class IndexClient {
    private static Gson prettygson = new GsonBuilder().setPrettyPrinting().create();
    private Client jerseyClient;
    private EndpointProvider endpointProvider = null;
    private String scope = null;
    private static final Logger logger = LoggerFactory.getLogger(IndexClient.class);

    protected IndexClient() {
    }

    public void initiateClient(String scope) {
        this.scope = scope;
        this.jerseyClient = Client.create();
        this.endpointProvider = new EndpointProvider(scope);
        logger.debug("Found " + this.endpointProvider.endpointsNumber() + " index endpoints");
    }

    public EndpointProvider getEndpointProvider() {
        return this.endpointProvider;
    }

    public boolean createIndex(String collectionID) throws NoAvailableIndexServiceInstance {
        int code = -1;
        while (this.endpointProvider.endpointsNumber() > 0) {
            String ep = this.endpointProvider.getAnEndpoint();
            try {
                WebResource webResource = this.jerseyClient.resource(ep);
                WebResource tempWebResource = webResource.path("create").path(collectionID);
                ClientResponse resp = (ClientResponse)((WebResource.Builder)((WebResource.Builder)tempWebResource.accept(new String[]{"application/json; charset=UTF-8"}).type("application/x-www-form-urlencoded")).header("gcube-scope", (Object)this.scope)).post(ClientResponse.class);
                code = resp.getStatus();
                resp.close();
                return code == ClientResponse.Status.CREATED.getStatusCode();
            }
            catch (ClientHandlerException | UniformInterfaceException ex) {
                logger.debug("Endpoint \"" + ep + "\" seems to be dead. Will be blacklisted for a while");
                this.endpointProvider.remove(ep);
            }
        }
        throw new NoAvailableIndexServiceInstance("There are no available index services within scope " + this.scope);
    }

    @Cacheable(value={"COLLECTION_NAMES"})
    public ArrayList<String> getCollections() throws NoAvailableIndexServiceInstance {
        while (this.endpointProvider.endpointsNumber() > 0) {
            String jsonCollResp = "";
            String ep = this.endpointProvider.getAnEndpoint();
            try {
                WebResource webResource = this.jerseyClient.resource(ep);
                WebResource tempWebResource = webResource.path("listCollections");
                ClientResponse resp = (ClientResponse)((WebResource.Builder)tempWebResource.accept(new String[]{"application/json; charset=UTF-8"}).header("gcube-scope", (Object)this.scope)).get(ClientResponse.class);
                jsonCollResp = (String)resp.getEntity(String.class);
                resp.close();
                try {
                    return (ArrayList)prettygson.fromJson(jsonCollResp, new TypeToken<ArrayList<String>>(){}.getType());
                }
                catch (JsonSyntaxException jsonExcep) {
                    logger.debug("Could not deserialise datasources list. List empty?");
                    return new ArrayList<String>();
                }
            }
            catch (ClientHandlerException | UniformInterfaceException ex) {
                logger.debug("Endpoint \"" + ep + "\" seems to be dead. Will be blacklisted for a while");
                this.endpointProvider.remove(ep);
            }
        }
        throw new NoAvailableIndexServiceInstance("There are no available index services within scope " + this.scope);
    }

    @Cacheable(value={"COLLECTIONS_FIELDS"})
    public Map<String, List<String>> getAllCollectionFields() throws NoAvailableIndexServiceInstance {
        while (this.endpointProvider.endpointsNumber() > 0) {
            String ep = this.endpointProvider.getAnEndpoint();
            try {
                WebResource webResource = this.jerseyClient.resource(ep);
                WebResource tempWebResource = webResource.path("getAllCollectionFields").queryParam("aliasFields", Boolean.toString(true));
                ClientResponse resp = (ClientResponse)((WebResource.Builder)tempWebResource.accept(new String[]{"application/json; charset=UTF-8"}).header("gcube-scope", (Object)this.scope)).get(ClientResponse.class);
                String jsonCollResp = (String)resp.getEntity(String.class);
                resp.close();
                Map result = (Map)prettygson.fromJson(jsonCollResp, new TypeToken<Map<String, List<String>>>(){}.getType());
                return result;
            }
            catch (ClientHandlerException | UniformInterfaceException ex) {
                logger.debug("Endpoint \"" + ep + "\" seems to be dead. Will be blacklisted for a while");
                this.endpointProvider.remove(ep);
            }
        }
        throw new NoAvailableIndexServiceInstance("There are no available index services within scope " + this.scope);
    }

    public boolean insertJson(String collectionID, String recordID, String recordJSON) throws NoAvailableIndexServiceInstance {
        while (this.endpointProvider.endpointsNumber() > 0) {
            String ep = this.endpointProvider.getAnEndpoint();
            try {
                WebResource webResource = this.jerseyClient.resource(ep);
                WebResource tempWebResource = webResource.path("insert").path(collectionID).path(recordID);
                MultivaluedMapImpl formData = new MultivaluedMapImpl();
                formData.add((Object)"recordJSON", (Object)recordJSON);
                ClientResponse resp = (ClientResponse)((WebResource.Builder)((WebResource.Builder)tempWebResource.accept(new String[]{"application/json; charset=UTF-8"}).type("application/x-www-form-urlencoded; charset=UTF-8")).header("gcube-scope", (Object)this.scope)).post(ClientResponse.class, (Object)formData);
                int code = resp.getStatus();
                resp.close();
                return code == ClientResponse.Status.CREATED.getStatusCode();
            }
            catch (ClientHandlerException | UniformInterfaceException ex) {
                logger.debug("Endpoint \"" + ep + "\" seems to be dead. Will be blacklisted for a while");
                this.endpointProvider.remove(ep);
            }
        }
        throw new NoAvailableIndexServiceInstance("There are no available index services within scope " + this.scope);
    }

    public boolean insertJson(String collectionID, String recordJSON) throws NoAvailableIndexServiceInstance {
        while (this.endpointProvider.endpointsNumber() > 0) {
            String ep = this.endpointProvider.getAnEndpoint();
            try {
                WebResource webResource = this.jerseyClient.resource(ep);
                WebResource tempWebResource = webResource.path("insert").path(collectionID);
                MultivaluedMapImpl formData = new MultivaluedMapImpl();
                formData.add((Object)"recordJSON", (Object)recordJSON);
                ClientResponse resp = (ClientResponse)((WebResource.Builder)((WebResource.Builder)tempWebResource.accept(new String[]{"application/json; charset=UTF-8"}).type("application/x-www-form-urlencoded; charset=UTF-8")).header("gcube-scope", (Object)this.scope)).post(ClientResponse.class, (Object)formData);
                int code = resp.getStatus();
                if (code != ClientResponse.Status.CREATED.getStatusCode()) {
                    System.out.println("THIS RECORD COULD NOT BE INSERTED: " + recordJSON);
                }
                resp.close();
                return code == ClientResponse.Status.CREATED.getStatusCode();
            }
            catch (ClientHandlerException | UniformInterfaceException ex) {
                logger.debug("Endpoint \"" + ep + "\" seems to be dead. Will be blacklisted for a while");
                this.endpointProvider.remove(ep);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        throw new NoAvailableIndexServiceInstance("There are no available index services within scope " + this.scope);
    }

    public boolean delete(String collectionID, String recordID) throws NoAvailableIndexServiceInstance {
        while (this.endpointProvider.endpointsNumber() > 0) {
            String ep = this.endpointProvider.getAnEndpoint();
            try {
                WebResource webResource = this.jerseyClient.resource(ep);
                WebResource tempWebResource = webResource.path("delete").path(collectionID).path(recordID);
                ClientResponse resp = (ClientResponse)((WebResource.Builder)tempWebResource.accept(new String[]{"application/json; charset=UTF-8"}).header("gcube-scope", (Object)this.scope)).delete(ClientResponse.class);
                int code = resp.getStatus();
                resp.close();
                return code == ClientResponse.Status.OK.getStatusCode();
            }
            catch (ClientHandlerException | UniformInterfaceException ex) {
                logger.debug("Endpoint \"" + ep + "\" seems to be dead. Will be blacklisted for a while");
                this.endpointProvider.remove(ep);
            }
        }
        throw new NoAvailableIndexServiceInstance("There are no available index services within scope " + this.scope);
    }

    public boolean dropCollection(String collectionID) throws NoAvailableIndexServiceInstance {
        while (this.endpointProvider.endpointsNumber() > 0) {
            String ep = this.endpointProvider.getAnEndpoint();
            try {
                WebResource webResource = this.jerseyClient.resource(ep);
                WebResource tempWebResource = webResource.path("dropCollection").path(collectionID);
                ClientResponse resp = (ClientResponse)((WebResource.Builder)tempWebResource.accept(new String[]{"application/json; charset=UTF-8"}).header("gcube-scope", (Object)this.scope)).delete(ClientResponse.class);
                int code = resp.getStatus();
                resp.close();
                return code == 200;
            }
            catch (ClientHandlerException | UniformInterfaceException ex) {
                logger.debug("Endpoint \"" + ep + "\" seems to be dead. Will be blacklisted for a while");
                this.endpointProvider.remove(ep);
            }
        }
        throw new NoAvailableIndexServiceInstance("There are no available index services within scope " + this.scope);
    }

    public boolean setCollectionFieldsAlias(String collectionID, Map<String, String> fieldAlias) throws NoAvailableIndexServiceInstance {
        while (this.endpointProvider.endpointsNumber() > 0) {
            String ep = this.endpointProvider.getAnEndpoint();
            try {
                WebResource webResource = this.jerseyClient.resource(ep);
                WebResource tempWebResource = webResource.path("setCollectionFieldsAlias").queryParam("collectionID", collectionID);
                String fieldAliasJSON = prettygson.toJson(fieldAlias);
                MultivaluedMapImpl formData = new MultivaluedMapImpl();
                formData.add((Object)"mappingsJSON", (Object)fieldAliasJSON);
                ClientResponse resp = (ClientResponse)((WebResource.Builder)((WebResource.Builder)tempWebResource.accept(new String[]{"application/json; charset=UTF-8"}).type("application/x-www-form-urlencoded")).header("gcube-scope", (Object)this.scope)).post(ClientResponse.class, (Object)formData);
                int code = resp.getStatus();
                resp.close();
                return code == ClientResponse.Status.CREATED.getStatusCode();
            }
            catch (ClientHandlerException | UniformInterfaceException ex) {
                logger.debug("Endpoint \"" + ep + "\" seems to be dead. Will be blacklisted for a while");
                this.endpointProvider.remove(ep);
            }
        }
        throw new NoAvailableIndexServiceInstance("There are no available index services within scope " + this.scope);
    }

    public boolean deleteCollectionFieldsAlias(String collectionID) throws NoAvailableIndexServiceInstance {
        while (this.endpointProvider.endpointsNumber() > 0) {
            String ep = this.endpointProvider.getAnEndpoint();
            try {
                WebResource webResource = this.jerseyClient.resource(ep);
                WebResource tempWebResource = webResource.path("deleteCollectionFieldsAlias").queryParam("collectionID", collectionID);
                ClientResponse resp = (ClientResponse)((WebResource.Builder)tempWebResource.accept(new String[]{"application/json; charset=UTF-8"}).header("gcube-scope", (Object)this.scope)).delete(ClientResponse.class);
                int code = resp.getStatus();
                resp.close();
                return code == 200;
            }
            catch (ClientHandlerException | UniformInterfaceException ex) {
                logger.debug("Endpoint \"" + ep + "\" seems to be dead. Will be blacklisted for a while");
                this.endpointProvider.remove(ep);
            }
        }
        throw new NoAvailableIndexServiceInstance("There are no available index services within scope " + this.scope);
    }

    @Cacheable(value={"COLLECTIONS_FIELDS_ALIASES"})
    public Map<String, Map<String, String>> getAllCollectionFieldsAliases(boolean fromIndexToView) throws NoAvailableIndexServiceInstance {
        return this.getCollectionFieldsAlias("", fromIndexToView);
    }

    @Cacheable(value={"COLLECTIONS_FIELDS_ALIASES"})
    public Map<String, Map<String, String>> getCollectionFieldsAlias(String collectionID, boolean fromIndexToView) throws NoAvailableIndexServiceInstance {
        while (this.endpointProvider.endpointsNumber() > 0) {
            String ep = this.endpointProvider.getAnEndpoint();
            try {
                if (collectionID == null || collectionID.isEmpty()) {
                    collectionID = "";
                }
                WebResource webResource = this.jerseyClient.resource(ep);
                WebResource tempWebResource = webResource.path("getCollectionFieldsAlias").queryParam("collectionID", collectionID).queryParam("fromIndexToView", Boolean.toString(fromIndexToView));
                ClientResponse resp = (ClientResponse)((WebResource.Builder)tempWebResource.accept(new String[]{"application/json; charset=UTF-8"}).header("gcube-scope", (Object)this.scope)).get(ClientResponse.class);
                String jsonCollFieldsAlias = (String)resp.getEntity(String.class);
                resp.close();
                if (jsonCollFieldsAlias == null || jsonCollFieldsAlias.isEmpty()) {
                    return new HashMap<String, Map<String, String>>();
                }
                return (Map)prettygson.fromJson(jsonCollFieldsAlias, new TypeToken<Map<String, Map<String, String>>>(){}.getType());
            }
            catch (ClientHandlerException | UniformInterfaceException ex) {
                logger.debug("Endpoint \"" + ep + "\" seems to be dead. Will be blacklisted for a while");
                this.endpointProvider.remove(ep);
            }
        }
        throw new NoAvailableIndexServiceInstance("There are no available index services within scope " + this.scope);
    }

    @Cacheable(value={"JSON_TRANSFORMERS"})
    public Map<String, String> getAllJSONTransformers() throws NoAvailableIndexServiceInstance {
        return this.getJSONTransformer("");
    }

    @Cacheable(value={"JSON_TRANSFORMERS"})
    public HashMap<String, String> getJSONTransformer(String collectionID) throws NoAvailableIndexServiceInstance {
        while (this.endpointProvider.endpointsNumber() > 0) {
            String ep = this.endpointProvider.getAnEndpoint();
            try {
                if (collectionID == null || collectionID.isEmpty()) {
                    collectionID = "";
                }
                WebResource webResource = this.jerseyClient.resource(ep);
                WebResource tempWebResource = webResource.path("getJSONTransformer").queryParam("collectionID", collectionID);
                ClientResponse resp = (ClientResponse)((WebResource.Builder)tempWebResource.accept(new String[]{"application/json; charset=UTF-8"}).header("gcube-scope", (Object)this.scope)).get(ClientResponse.class);
                String jsonMap = (String)resp.getEntity(String.class);
                resp.close();
                return (HashMap)prettygson.fromJson(jsonMap, new TypeToken<HashMap<String, String>>(){}.getType());
            }
            catch (ClientHandlerException | UniformInterfaceException ex) {
                logger.debug("Endpoint \"" + ep + "\" seems to be dead. Will be blacklisted for a while");
                this.endpointProvider.remove(ep);
            }
        }
        throw new NoAvailableIndexServiceInstance("There are no available index services within scope " + this.scope);
    }

    public boolean setJSONTransformer(String collectionID, String transformerJSON) throws NoAvailableIndexServiceInstance {
        while (this.endpointProvider.endpointsNumber() > 0) {
            String ep = this.endpointProvider.getAnEndpoint();
            try {
                if (collectionID == null || collectionID.isEmpty()) {
                    logger.error("No collection id specified to set the transformer json");
                    return false;
                }
                WebResource webResource = this.jerseyClient.resource(ep);
                WebResource tempWebResource = webResource.path("setJSONTransformer").queryParam("collectionID", collectionID);
                MultivaluedMapImpl formData = new MultivaluedMapImpl();
                formData.add((Object)"transformerJSON", (Object)transformerJSON);
                ClientResponse resp = (ClientResponse)((WebResource.Builder)((WebResource.Builder)tempWebResource.accept(new String[]{"application/json; charset=UTF-8"}).type("application/x-www-form-urlencoded")).header("gcube-scope", (Object)this.scope)).post(ClientResponse.class, (Object)formData);
                resp.close();
                return resp.getStatus() == ClientResponse.Status.CREATED.getStatusCode();
            }
            catch (ClientHandlerException | UniformInterfaceException ex) {
                logger.debug("Endpoint \"" + ep + "\" seems to be dead. Will be blacklisted for a while");
                this.endpointProvider.remove(ep);
            }
        }
        throw new NoAvailableIndexServiceInstance("There are no available index services within scope " + this.scope);
    }

    public boolean deleteJSONTransformer(String collectionID) throws NoAvailableIndexServiceInstance {
        while (this.endpointProvider.endpointsNumber() > 0) {
            String ep = this.endpointProvider.getAnEndpoint();
            try {
                WebResource webResource = this.jerseyClient.resource(ep);
                WebResource tempWebResource = webResource.path("deleteJSONTransformer").queryParam("collectionID", collectionID);
                ClientResponse resp = (ClientResponse)((WebResource.Builder)tempWebResource.accept(new String[]{"application/json; charset=UTF-8"}).header("gcube-scope", (Object)this.scope)).delete(ClientResponse.class);
                int code = resp.getStatus();
                resp.close();
                return code == 200;
            }
            catch (ClientHandlerException | UniformInterfaceException ex) {
                logger.debug("Endpoint \"" + ep + "\" seems to be dead. Will be blacklisted for a while");
                this.endpointProvider.remove(ep);
            }
        }
        throw new NoAvailableIndexServiceInstance("There are no available index services within scope " + this.scope);
    }

    public Map<String, CollectionInfo> getAllCollectionsInfo() throws NoAvailableIndexServiceInstance {
        return this.getCollectionInfo(null);
    }

    @Cacheable(value={"COLLECTION_INFOS"})
    public Map<String, CollectionInfo> getCollectionInfo(String collectionID) throws NoAvailableIndexServiceInstance {
        while (this.endpointProvider.endpointsNumber() > 0) {
            String ep = this.endpointProvider.getAnEndpoint();
            try {
                if (collectionID == null || collectionID.isEmpty()) {
                    collectionID = "";
                }
                WebResource webResource = this.jerseyClient.resource(ep);
                WebResource tempWebResource = webResource.path("getCollectionInfo").queryParam("collectionID", collectionID);
                ClientResponse resp = (ClientResponse)((WebResource.Builder)tempWebResource.accept(new String[]{"application/json; charset=UTF-8"}).header("gcube-scope", (Object)this.scope)).get(ClientResponse.class);
                String jsonMap = (String)resp.getEntity(String.class);
                resp.close();
                HashMap<String, CollectionInfo> output = new HashMap<String, CollectionInfo>();
                Map map = (Map)prettygson.fromJson(jsonMap, new TypeToken<HashMap<String, String>>(){}.getType());
                Iterator it = map.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry pair = it.next();
                    output.put(((String)pair.getKey()).toString(), (CollectionInfo)prettygson.fromJson(((String)pair.getValue()).toString(), CollectionInfo.class));
                    it.remove();
                }
                return output;
            }
            catch (ClientHandlerException | UniformInterfaceException ex) {
                logger.debug("Endpoint \"" + ep + "\" seems to be dead. Will be blacklisted for a while");
                this.endpointProvider.remove(ep);
            }
        }
        throw new NoAvailableIndexServiceInstance("There are no available index services within scope " + this.scope);
    }

    public boolean setCollectionInfo(String collectionID, CollectionInfo collInfo) throws NoAvailableIndexServiceInstance {
        while (this.endpointProvider.endpointsNumber() > 0) {
            String ep = this.endpointProvider.getAnEndpoint();
            try {
                if (collectionID == null || collectionID.isEmpty()) {
                    logger.error("No collection id specified to set the transformer json");
                    return false;
                }
                if (!collectionID.equals(collInfo.getId())) {
                    collInfo.setId(collectionID);
                }
                WebResource webResource = this.jerseyClient.resource(ep);
                WebResource tempWebResource = webResource.path("setCollectionInfo").queryParam("collectionID", collectionID);
                MultivaluedMapImpl formData = new MultivaluedMapImpl();
                formData.add((Object)"infoJSON", (Object)prettygson.toJson((Object)collInfo));
                ClientResponse resp = (ClientResponse)((WebResource.Builder)((WebResource.Builder)tempWebResource.accept(new String[]{"application/json; charset=UTF-8"}).type("application/x-www-form-urlencoded; charset=UTF-8")).header("gcube-scope", (Object)this.scope)).post(ClientResponse.class, (Object)formData);
                resp.close();
                return resp.getStatus() == ClientResponse.Status.CREATED.getStatusCode();
            }
            catch (ClientHandlerException | UniformInterfaceException ex) {
                logger.debug("Endpoint \"" + ep + "\" seems to be dead. Will be blacklisted for a while");
                this.endpointProvider.remove(ep);
            }
        }
        throw new NoAvailableIndexServiceInstance("There are no available index services within scope " + this.scope);
    }

    public boolean deleteCollectionInfo(String collectionID) throws NoAvailableIndexServiceInstance {
        while (this.endpointProvider.endpointsNumber() > 0) {
            String ep = this.endpointProvider.getAnEndpoint();
            try {
                WebResource webResource = this.jerseyClient.resource(ep);
                WebResource tempWebResource = webResource.path("deleteCollectionInfo").queryParam("collectionID", collectionID);
                ClientResponse resp = (ClientResponse)((WebResource.Builder)tempWebResource.accept(new String[]{"application/json; charset=UTF-8"}).header("gcube-scope", (Object)this.scope)).delete(ClientResponse.class);
                int code = resp.getStatus();
                resp.close();
                return code == 200;
            }
            catch (ClientHandlerException | UniformInterfaceException ex) {
                logger.debug("Endpoint \"" + ep + "\" seems to be dead. Will be blacklisted for a while");
                this.endpointProvider.remove(ep);
            }
        }
        throw new NoAvailableIndexServiceInstance("There are no available index services within scope " + this.scope);
    }

    public Search_Response search(Query query) throws NoAvailableIndexServiceInstance {
        while (this.endpointProvider.endpointsNumber() > 0) {
            String ep = this.endpointProvider.getAnEndpoint();
            try {
                WebResource webResource = this.jerseyClient.resource(ep);
                WebResource tempWebResource = webResource.path("search");
                String queryJson = prettygson.toJson((Object)query);
                queryJson = Toolbox.encode((String)queryJson);
                MultivaluedMapImpl formData = new MultivaluedMapImpl();
                formData.add((Object)"query", (Object)queryJson);
                ClientResponse resp = (ClientResponse)((WebResource.Builder)((WebResource.Builder)tempWebResource.accept(new String[]{"application/json; charset=UTF-8"}).type("application/x-www-form-urlencoded; charset=UTF-8")).header("gcube-scope", (Object)this.scope)).post(ClientResponse.class, (Object)formData);
                String jsonResults = (String)resp.getEntity(String.class);
                resp.close();
                return (Search_Response)prettygson.fromJson(jsonResults, Search_Response.class);
            }
            catch (ClientHandlerException | UniformInterfaceException ex) {
                logger.debug("Endpoint \"" + ep + "\" seems to be dead. Will be blacklisted for a while");
                this.endpointProvider.remove(ep);
            }
        }
        throw new NoAvailableIndexServiceInstance("There are no available index services within scope " + this.scope);
    }
}

